package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{
  XksProxyAuthenticationRawSecretAccessKeyType,
  XksProxyAuthenticationAccessKeyIdType
}
import scala.jdk.CollectionConverters._
final case class XksProxyAuthenticationCredentialType(
    accessKeyId: XksProxyAuthenticationAccessKeyIdType,
    rawSecretAccessKey: XksProxyAuthenticationRawSecretAccessKeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType = {
    import XksProxyAuthenticationCredentialType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType
      .builder()
      .accessKeyId(
        XksProxyAuthenticationAccessKeyIdType.unwrap(
          accessKeyId
        ): java.lang.String
      )
      .rawSecretAccessKey(
        XksProxyAuthenticationRawSecretAccessKeyType.unwrap(
          rawSecretAccessKey
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly =
    zio.aws.kms.model.XksProxyAuthenticationCredentialType.wrap(buildAwsValue())
}
object XksProxyAuthenticationCredentialType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.XksProxyAuthenticationCredentialType =
      zio.aws.kms.model
        .XksProxyAuthenticationCredentialType(accessKeyId, rawSecretAccessKey)
    def accessKeyId: XksProxyAuthenticationAccessKeyIdType
    def rawSecretAccessKey: XksProxyAuthenticationRawSecretAccessKeyType
    def getAccessKeyId
        : ZIO[Any, Nothing, XksProxyAuthenticationAccessKeyIdType] =
      ZIO.succeed(accessKeyId)
    def getRawSecretAccessKey
        : ZIO[Any, Nothing, XksProxyAuthenticationRawSecretAccessKeyType] =
      ZIO.succeed(rawSecretAccessKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType
  ) extends zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly {
    override val accessKeyId: XksProxyAuthenticationAccessKeyIdType =
      zio.aws.kms.model.primitives
        .XksProxyAuthenticationAccessKeyIdType(impl.accessKeyId())
    override val rawSecretAccessKey
        : XksProxyAuthenticationRawSecretAccessKeyType =
      zio.aws.kms.model.primitives
        .XksProxyAuthenticationRawSecretAccessKeyType(impl.rawSecretAccessKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType
  ): zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly =
    new Wrapper(impl)
}
