package zio.aws.kms.model
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{MarkerType, LimitType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKeysRequest(
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListKeysRequest = {
    import ListKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListKeysRequest
      .builder()
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListKeysRequest.ReadOnly =
    zio.aws.kms.model.ListKeysRequest.wrap(buildAwsValue())
}
object ListKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListKeysRequest = zio.aws.kms.model
      .ListKeysRequest(limit.map(value => value), marker.map(value => value))
    def limit: Optional[LimitType]
    def marker: Optional[MarkerType]
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListKeysRequest
  ) extends zio.aws.kms.model.ListKeysRequest.ReadOnly {
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListKeysRequest
  ): zio.aws.kms.model.ListKeysRequest.ReadOnly = new Wrapper(impl)
}
