package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait MacAlgorithmSpec {
  def unwrap: software.amazon.awssdk.services.kms.model.MacAlgorithmSpec
}
object MacAlgorithmSpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.MacAlgorithmSpec
  ): zio.aws.kms.model.MacAlgorithmSpec = value match {
    case software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_224 =>
      val r = HMAC_SHA_224
      r
    case software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_256 =>
      val r = HMAC_SHA_256
      r
    case software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_384 =>
      val r = HMAC_SHA_384
      r
    case software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_512 =>
      val r = HMAC_SHA_512
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.MacAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MacAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.UNKNOWN_TO_SDK_VERSION
  }
  case object HMAC_SHA_224 extends zio.aws.kms.model.MacAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MacAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_224
  }
  case object HMAC_SHA_256 extends zio.aws.kms.model.MacAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MacAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_256
  }
  case object HMAC_SHA_384 extends zio.aws.kms.model.MacAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MacAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_384
  }
  case object HMAC_SHA_512 extends zio.aws.kms.model.MacAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MacAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.MacAlgorithmSpec.HMAC_SHA_512
  }
}
