package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, PlaintextType, CiphertextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyResponse(
    ciphertextBlob: Optional[CiphertextType] = Optional.Absent,
    plaintext: Optional[PlaintextType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse = {
    import GenerateDataKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse
      .builder()
      .optionallyWith(
        ciphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.ciphertextBlob)
      .optionallyWith(
        plaintext.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.plaintext)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyResponse.wrap(buildAwsValue())
}
object GenerateDataKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyResponse =
      zio.aws.kms.model.GenerateDataKeyResponse(
        ciphertextBlob.map(value => value),
        plaintext.map(value => value),
        keyId.map(value => value)
      )
    def ciphertextBlob: Optional[CiphertextType]
    def plaintext: Optional[PlaintextType]
    def keyId: Optional[KeyIdType]
    def getCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("ciphertextBlob", ciphertextBlob)
    def getPlaintext: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("plaintext", plaintext)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse
  ) extends zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly {
    override val ciphertextBlob: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphertextBlob())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val plaintext: Optional[PlaintextType] = zio.aws.core.internal
      .optionalFromNullable(impl.plaintext())
      .map(value =>
        zio.aws.kms.model.primitives
          .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse
  ): zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly = new Wrapper(impl)
}
