package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  NullableBooleanType,
  GrantTokenType,
  PlaintextType,
  KeyIdType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SignRequest(
    keyId: KeyIdType,
    message: PlaintextType,
    messageType: Optional[zio.aws.kms.model.MessageType] = Optional.Absent,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kms.model.SignRequest = {
    import SignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.SignRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .message(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          message.toArray[Byte]
        )
      )
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .signingAlgorithm(signingAlgorithm.unwrap)
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.SignRequest.ReadOnly =
    zio.aws.kms.model.SignRequest.wrap(buildAwsValue())
}
object SignRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.SignRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.SignRequest =
      zio.aws.kms.model.SignRequest(
        keyId,
        message,
        messageType.map(value => value),
        grantTokens.map(value => value),
        signingAlgorithm,
        dryRun.map(value => value)
      )
    def keyId: KeyIdType
    def message: PlaintextType
    def messageType: Optional[zio.aws.kms.model.MessageType]
    def grantTokens: Optional[List[GrantTokenType]]
    def signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec
    def dryRun: Optional[NullableBooleanType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getMessage: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(message)
    def getMessageType: ZIO[Any, AwsError, zio.aws.kms.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getSigningAlgorithm
        : ZIO[Any, Nothing, zio.aws.kms.model.SigningAlgorithmSpec] =
      ZIO.succeed(signingAlgorithm)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.SignRequest
  ) extends zio.aws.kms.model.SignRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val message: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.message().asByteArrayUnsafe()))
    override val messageType: Optional[zio.aws.kms.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.kms.model.MessageType.wrap(value))
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec =
      zio.aws.kms.model.SigningAlgorithmSpec.wrap(impl.signingAlgorithm())
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.SignRequest
  ): zio.aws.kms.model.SignRequest.ReadOnly = new Wrapper(impl)
}
