package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  NullableBooleanType,
  GrantIdType,
  KeyIdType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevokeGrantRequest(
    keyId: KeyIdType,
    grantId: GrantIdType,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.RevokeGrantRequest = {
    import RevokeGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.RevokeGrantRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .grantId(GrantIdType.unwrap(grantId): java.lang.String)
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.RevokeGrantRequest.ReadOnly =
    zio.aws.kms.model.RevokeGrantRequest.wrap(buildAwsValue())
}
object RevokeGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.RevokeGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.RevokeGrantRequest = zio.aws.kms.model
      .RevokeGrantRequest(keyId, grantId, dryRun.map(value => value))
    def keyId: KeyIdType
    def grantId: GrantIdType
    def dryRun: Optional[NullableBooleanType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getGrantId: ZIO[Any, Nothing, GrantIdType] = ZIO.succeed(grantId)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.RevokeGrantRequest
  ) extends zio.aws.kms.model.RevokeGrantRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val grantId: GrantIdType =
      zio.aws.kms.model.primitives.GrantIdType(impl.grantId())
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.RevokeGrantRequest
  ): zio.aws.kms.model.RevokeGrantRequest.ReadOnly = new Wrapper(impl)
}
