package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait MultiRegionKeyType {
  def unwrap: software.amazon.awssdk.services.kms.model.MultiRegionKeyType
}
object MultiRegionKeyType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.MultiRegionKeyType
  ): zio.aws.kms.model.MultiRegionKeyType = value match {
    case software.amazon.awssdk.services.kms.model.MultiRegionKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.MultiRegionKeyType.PRIMARY =>
      val r = PRIMARY
      r
    case software.amazon.awssdk.services.kms.model.MultiRegionKeyType.REPLICA =>
      val r = REPLICA
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.MultiRegionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MultiRegionKeyType =
      software.amazon.awssdk.services.kms.model.MultiRegionKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIMARY extends zio.aws.kms.model.MultiRegionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MultiRegionKeyType =
      software.amazon.awssdk.services.kms.model.MultiRegionKeyType.PRIMARY
  }
  case object REPLICA extends zio.aws.kms.model.MultiRegionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.MultiRegionKeyType =
      software.amazon.awssdk.services.kms.model.MultiRegionKeyType.REPLICA
  }
}
