package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  NullableBooleanType,
  GrantTokenType,
  KeyIdType,
  PlaintextType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateMacRequest(
    message: PlaintextType,
    keyId: KeyIdType,
    macAlgorithm: zio.aws.kms.model.MacAlgorithmSpec,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateMacRequest = {
    import GenerateMacRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateMacRequest
      .builder()
      .message(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          message.toArray[Byte]
        )
      )
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .macAlgorithm(macAlgorithm.unwrap)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateMacRequest.ReadOnly =
    zio.aws.kms.model.GenerateMacRequest.wrap(buildAwsValue())
}
object GenerateMacRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateMacRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateMacRequest =
      zio.aws.kms.model.GenerateMacRequest(
        message,
        keyId,
        macAlgorithm,
        grantTokens.map(value => value),
        dryRun.map(value => value)
      )
    def message: PlaintextType
    def keyId: KeyIdType
    def macAlgorithm: zio.aws.kms.model.MacAlgorithmSpec
    def grantTokens: Optional[List[GrantTokenType]]
    def dryRun: Optional[NullableBooleanType]
    def getMessage: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(message)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getMacAlgorithm: ZIO[Any, Nothing, zio.aws.kms.model.MacAlgorithmSpec] =
      ZIO.succeed(macAlgorithm)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateMacRequest
  ) extends zio.aws.kms.model.GenerateMacRequest.ReadOnly {
    override val message: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.message().asByteArrayUnsafe()))
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val macAlgorithm: zio.aws.kms.model.MacAlgorithmSpec =
      zio.aws.kms.model.MacAlgorithmSpec.wrap(impl.macAlgorithm())
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateMacRequest
  ): zio.aws.kms.model.GenerateMacRequest.ReadOnly = new Wrapper(impl)
}
