package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  NullableBooleanType,
  EncryptionContextKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyPairWithoutPlaintextRequest(
    encryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    keyId: KeyIdType,
    keyPairSpec: zio.aws.kms.model.DataKeyPairSpec,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest = {
    import GenerateDataKeyPairWithoutPlaintextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
      .builder()
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .keyPairSpec(keyPairSpec.unwrap)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
      .wrap(buildAwsValue())
}
object GenerateDataKeyPairWithoutPlaintextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest =
      zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest(
        encryptionContext.map(value => value),
        keyId,
        keyPairSpec,
        grantTokens.map(value => value),
        dryRun.map(value => value)
      )
    def encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def keyId: KeyIdType
    def keyPairSpec: zio.aws.kms.model.DataKeyPairSpec
    def grantTokens: Optional[List[GrantTokenType]]
    def dryRun: Optional[NullableBooleanType]
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getKeyPairSpec: ZIO[Any, Nothing, zio.aws.kms.model.DataKeyPairSpec] =
      ZIO.succeed(keyPairSpec)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
  ) extends zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest.ReadOnly {
    override val encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val keyPairSpec: zio.aws.kms.model.DataKeyPairSpec =
      zio.aws.kms.model.DataKeyPairSpec.wrap(impl.keyPairSpec())
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
  ): zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest.ReadOnly =
    new Wrapper(impl)
}
