package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.XksKeyIdType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class XksKeyConfigurationType(
    id: Optional[XksKeyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.XksKeyConfigurationType = {
    import XksKeyConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.XksKeyConfigurationType
      .builder()
      .optionallyWith(
        id.map(value => XksKeyIdType.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.XksKeyConfigurationType.ReadOnly =
    zio.aws.kms.model.XksKeyConfigurationType.wrap(buildAwsValue())
}
object XksKeyConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.XksKeyConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.XksKeyConfigurationType =
      zio.aws.kms.model.XksKeyConfigurationType(id.map(value => value))
    def id: Optional[XksKeyIdType]
    def getId: ZIO[Any, AwsError, XksKeyIdType] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.XksKeyConfigurationType
  ) extends zio.aws.kms.model.XksKeyConfigurationType.ReadOnly {
    override val id: Optional[XksKeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kms.model.primitives.XksKeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.XksKeyConfigurationType
  ): zio.aws.kms.model.XksKeyConfigurationType.ReadOnly = new Wrapper(impl)
}
