package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters._
final case class DeleteImportedKeyMaterialRequest(keyId: KeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest = {
    import DeleteImportedKeyMaterialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DeleteImportedKeyMaterialRequest.ReadOnly =
    zio.aws.kms.model.DeleteImportedKeyMaterialRequest.wrap(buildAwsValue())
}
object DeleteImportedKeyMaterialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DeleteImportedKeyMaterialRequest =
      zio.aws.kms.model.DeleteImportedKeyMaterialRequest(keyId)
    def keyId: KeyIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest
  ) extends zio.aws.kms.model.DeleteImportedKeyMaterialRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest
  ): zio.aws.kms.model.DeleteImportedKeyMaterialRequest.ReadOnly = new Wrapper(
    impl
  )
}
