package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait DataKeySpec {
  def unwrap: software.amazon.awssdk.services.kms.model.DataKeySpec
}
object DataKeySpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.DataKeySpec
  ): zio.aws.kms.model.DataKeySpec = value match {
    case software.amazon.awssdk.services.kms.model.DataKeySpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.DataKeySpec.AES_256 =>
      val r = AES_256
      r
    case software.amazon.awssdk.services.kms.model.DataKeySpec.AES_128 =>
      val r = AES_128
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.DataKeySpec {
    override def unwrap: software.amazon.awssdk.services.kms.model.DataKeySpec =
      software.amazon.awssdk.services.kms.model.DataKeySpec.UNKNOWN_TO_SDK_VERSION
  }
  case object AES_256 extends zio.aws.kms.model.DataKeySpec {
    override def unwrap: software.amazon.awssdk.services.kms.model.DataKeySpec =
      software.amazon.awssdk.services.kms.model.DataKeySpec.AES_256
  }
  case object AES_128 extends zio.aws.kms.model.DataKeySpec {
    override def unwrap: software.amazon.awssdk.services.kms.model.DataKeySpec =
      software.amazon.awssdk.services.kms.model.DataKeySpec.AES_128
  }
}
