package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyResponse(
    keyMetadata: Optional[zio.aws.kms.model.KeyMetadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateKeyResponse = {
    import CreateKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateKeyResponse
      .builder()
      .optionallyWith(keyMetadata.map(value => value.buildAwsValue()))(
        _.keyMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateKeyResponse.ReadOnly =
    zio.aws.kms.model.CreateKeyResponse.wrap(buildAwsValue())
}
object CreateKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateKeyResponse = zio.aws.kms.model
      .CreateKeyResponse(keyMetadata.map(value => value.asEditable))
    def keyMetadata: Optional[zio.aws.kms.model.KeyMetadata.ReadOnly]
    def getKeyMetadata
        : ZIO[Any, AwsError, zio.aws.kms.model.KeyMetadata.ReadOnly] =
      AwsError.unwrapOptionField("keyMetadata", keyMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateKeyResponse
  ) extends zio.aws.kms.model.CreateKeyResponse.ReadOnly {
    override val keyMetadata: Optional[zio.aws.kms.model.KeyMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyMetadata())
        .map(value => zio.aws.kms.model.KeyMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateKeyResponse
  ): zio.aws.kms.model.CreateKeyResponse.ReadOnly = new Wrapper(impl)
}
