package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.BooleanType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetKeyRotationStatusResponse(
    keyRotationEnabled: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse = {
    import GetKeyRotationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse
      .builder()
      .optionallyWith(
        keyRotationEnabled.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.keyRotationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly =
    zio.aws.kms.model.GetKeyRotationStatusResponse.wrap(buildAwsValue())
}
object GetKeyRotationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetKeyRotationStatusResponse =
      zio.aws.kms.model
        .GetKeyRotationStatusResponse(keyRotationEnabled.map(value => value))
    def keyRotationEnabled: Optional[BooleanType]
    def getKeyRotationEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("keyRotationEnabled", keyRotationEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse
  ) extends zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly {
    override val keyRotationEnabled: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyRotationEnabled())
        .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse
  ): zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly = new Wrapper(impl)
}
