package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  CiphertextType,
  EncryptionContextValue,
  EncryptionContextKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DecryptRequest(
    ciphertextBlob: CiphertextType,
    encryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent,
    encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DecryptRequest = {
    import DecryptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DecryptRequest
      .builder()
      .ciphertextBlob(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          ciphertextBlob.toArray[Byte]
        )
      )
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DecryptRequest.ReadOnly =
    zio.aws.kms.model.DecryptRequest.wrap(buildAwsValue())
}
object DecryptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DecryptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DecryptRequest =
      zio.aws.kms.model.DecryptRequest(
        ciphertextBlob,
        encryptionContext.map(value => value),
        grantTokens.map(value => value),
        keyId.map(value => value),
        encryptionAlgorithm.map(value => value)
      )
    def ciphertextBlob: CiphertextType
    def encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def grantTokens: Optional[List[GrantTokenType]]
    def keyId: Optional[KeyIdType]
    def encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def getCiphertextBlob: ZIO[Any, Nothing, CiphertextType] =
      ZIO.succeed(ciphertextBlob)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DecryptRequest
  ) extends zio.aws.kms.model.DecryptRequest.ReadOnly {
    override val ciphertextBlob: CiphertextType =
      zio.aws.kms.model.primitives.CiphertextType(
        zio.Chunk.fromArray(impl.ciphertextBlob().asByteArrayUnsafe())
      )
    override val encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val encryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DecryptRequest
  ): zio.aws.kms.model.DecryptRequest.ReadOnly = new Wrapper(impl)
}
