package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  CloudHsmClusterIdType,
  KeyStorePasswordType,
  CustomKeyStoreNameType,
  CustomKeyStoreIdType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCustomKeyStoreRequest(
    customKeyStoreId: CustomKeyStoreIdType,
    newCustomKeyStoreName: Optional[CustomKeyStoreNameType] = Optional.Absent,
    keyStorePassword: Optional[KeyStorePasswordType] = Optional.Absent,
    cloudHsmClusterId: Optional[CloudHsmClusterIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest = {
    import UpdateCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
      .builder()
      .customKeyStoreId(
        CustomKeyStoreIdType.unwrap(customKeyStoreId): java.lang.String
      )
      .optionallyWith(
        newCustomKeyStoreName.map(value =>
          CustomKeyStoreNameType.unwrap(value): java.lang.String
        )
      )(_.newCustomKeyStoreName)
      .optionallyWith(
        keyStorePassword.map(value =>
          KeyStorePasswordType.unwrap(value): java.lang.String
        )
      )(_.keyStorePassword)
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.UpdateCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.UpdateCustomKeyStoreRequest.wrap(buildAwsValue())
}
object UpdateCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.UpdateCustomKeyStoreRequest =
      zio.aws.kms.model.UpdateCustomKeyStoreRequest(
        customKeyStoreId,
        newCustomKeyStoreName.map(value => value),
        keyStorePassword.map(value => value),
        cloudHsmClusterId.map(value => value)
      )
    def customKeyStoreId: CustomKeyStoreIdType
    def newCustomKeyStoreName: Optional[CustomKeyStoreNameType]
    def keyStorePassword: Optional[KeyStorePasswordType]
    def cloudHsmClusterId: Optional[CloudHsmClusterIdType]
    def getCustomKeyStoreId: ZIO[Any, Nothing, CustomKeyStoreIdType] =
      ZIO.succeed(customKeyStoreId)
    def getNewCustomKeyStoreName: ZIO[Any, AwsError, CustomKeyStoreNameType] =
      AwsError.unwrapOptionField("newCustomKeyStoreName", newCustomKeyStoreName)
    def getKeyStorePassword: ZIO[Any, AwsError, KeyStorePasswordType] =
      AwsError.unwrapOptionField("keyStorePassword", keyStorePassword)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
  ) extends zio.aws.kms.model.UpdateCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreId: CustomKeyStoreIdType =
      zio.aws.kms.model.primitives.CustomKeyStoreIdType(impl.customKeyStoreId())
    override val newCustomKeyStoreName: Optional[CustomKeyStoreNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newCustomKeyStoreName())
        .map(value =>
          zio.aws.kms.model.primitives.CustomKeyStoreNameType(value)
        )
    override val keyStorePassword: Optional[KeyStorePasswordType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyStorePassword())
        .map(value => zio.aws.kms.model.primitives.KeyStorePasswordType(value))
    override val cloudHsmClusterId: Optional[CloudHsmClusterIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudHsmClusterId())
        .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
  ): zio.aws.kms.model.UpdateCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
