package zio.aws.kms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{
  KeyIdType,
  ArnType,
  BooleanType,
  DateType,
  PendingWindowInDaysType,
  CloudHsmClusterIdType,
  CustomKeyStoreIdType,
  DescriptionType,
  AWSAccountIdType,
  NullableBooleanType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KeyMetadata(
    awsAccountId: Optional[AWSAccountIdType] = Optional.Absent,
    keyId: KeyIdType,
    arn: Optional[ArnType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    enabled: Optional[BooleanType] = Optional.Absent,
    description: Optional[DescriptionType] = Optional.Absent,
    keyUsage: Optional[zio.aws.kms.model.KeyUsageType] = Optional.Absent,
    keyState: Optional[zio.aws.kms.model.KeyState] = Optional.Absent,
    deletionDate: Optional[DateType] = Optional.Absent,
    validTo: Optional[DateType] = Optional.Absent,
    origin: Optional[zio.aws.kms.model.OriginType] = Optional.Absent,
    customKeyStoreId: Optional[CustomKeyStoreIdType] = Optional.Absent,
    cloudHsmClusterId: Optional[CloudHsmClusterIdType] = Optional.Absent,
    expirationModel: Optional[zio.aws.kms.model.ExpirationModelType] =
      Optional.Absent,
    keyManager: Optional[zio.aws.kms.model.KeyManagerType] = Optional.Absent,
    customerMasterKeySpec: Optional[zio.aws.kms.model.CustomerMasterKeySpec] =
      Optional.Absent,
    keySpec: Optional[zio.aws.kms.model.KeySpec] = Optional.Absent,
    encryptionAlgorithms: Optional[
      Iterable[zio.aws.kms.model.EncryptionAlgorithmSpec]
    ] = Optional.Absent,
    signingAlgorithms: Optional[
      Iterable[zio.aws.kms.model.SigningAlgorithmSpec]
    ] = Optional.Absent,
    multiRegion: Optional[NullableBooleanType] = Optional.Absent,
    multiRegionConfiguration: Optional[
      zio.aws.kms.model.MultiRegionConfiguration
    ] = Optional.Absent,
    pendingDeletionWindowInDays: Optional[PendingWindowInDaysType] =
      Optional.Absent,
    macAlgorithms: Optional[Iterable[zio.aws.kms.model.MacAlgorithmSpec]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kms.model.KeyMetadata = {
    import KeyMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.KeyMetadata
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          AWSAccountIdType.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(keyUsage.map(value => value.unwrap))(_.keyUsage)
      .optionallyWith(keyState.map(value => value.unwrap))(_.keyState)
      .optionallyWith(
        deletionDate.map(value => DateType.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(validTo.map(value => DateType.unwrap(value): Instant))(
        _.validTo
      )
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(expirationModel.map(value => value.unwrap))(
        _.expirationModel
      )
      .optionallyWith(keyManager.map(value => value.unwrap))(_.keyManager)
      .optionallyWith(customerMasterKeySpec.map(value => value.unwrap))(
        _.customerMasterKeySpec
      )
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(
        encryptionAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.encryptionAlgorithmsWithStrings)
      .optionallyWith(
        signingAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.signingAlgorithmsWithStrings)
      .optionallyWith(
        multiRegion.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.multiRegion)
      .optionallyWith(
        multiRegionConfiguration.map(value => value.buildAwsValue())
      )(_.multiRegionConfiguration)
      .optionallyWith(
        pendingDeletionWindowInDays.map(value =>
          PendingWindowInDaysType.unwrap(value): Integer
        )
      )(_.pendingDeletionWindowInDays)
      .optionallyWith(
        macAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.macAlgorithmsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.KeyMetadata.ReadOnly =
    zio.aws.kms.model.KeyMetadata.wrap(buildAwsValue())
}
object KeyMetadata {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.KeyMetadata] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.KeyMetadata =
      zio.aws.kms.model.KeyMetadata(
        awsAccountId.map(value => value),
        keyId,
        arn.map(value => value),
        creationDate.map(value => value),
        enabled.map(value => value),
        description.map(value => value),
        keyUsage.map(value => value),
        keyState.map(value => value),
        deletionDate.map(value => value),
        validTo.map(value => value),
        origin.map(value => value),
        customKeyStoreId.map(value => value),
        cloudHsmClusterId.map(value => value),
        expirationModel.map(value => value),
        keyManager.map(value => value),
        customerMasterKeySpec.map(value => value),
        keySpec.map(value => value),
        encryptionAlgorithms.map(value => value),
        signingAlgorithms.map(value => value),
        multiRegion.map(value => value),
        multiRegionConfiguration.map(value => value.asEditable),
        pendingDeletionWindowInDays.map(value => value),
        macAlgorithms.map(value => value)
      )
    def awsAccountId: Optional[AWSAccountIdType]
    def keyId: KeyIdType
    def arn: Optional[ArnType]
    def creationDate: Optional[DateType]
    def enabled: Optional[BooleanType]
    def description: Optional[DescriptionType]
    def keyUsage: Optional[zio.aws.kms.model.KeyUsageType]
    def keyState: Optional[zio.aws.kms.model.KeyState]
    def deletionDate: Optional[DateType]
    def validTo: Optional[DateType]
    def origin: Optional[zio.aws.kms.model.OriginType]
    def customKeyStoreId: Optional[CustomKeyStoreIdType]
    def cloudHsmClusterId: Optional[CloudHsmClusterIdType]
    def expirationModel: Optional[zio.aws.kms.model.ExpirationModelType]
    def keyManager: Optional[zio.aws.kms.model.KeyManagerType]
    def customerMasterKeySpec: Optional[zio.aws.kms.model.CustomerMasterKeySpec]
    def keySpec: Optional[zio.aws.kms.model.KeySpec]
    def encryptionAlgorithms
        : Optional[List[zio.aws.kms.model.EncryptionAlgorithmSpec]]
    def signingAlgorithms
        : Optional[List[zio.aws.kms.model.SigningAlgorithmSpec]]
    def multiRegion: Optional[NullableBooleanType]
    def multiRegionConfiguration
        : Optional[zio.aws.kms.model.MultiRegionConfiguration.ReadOnly]
    def pendingDeletionWindowInDays: Optional[PendingWindowInDaysType]
    def macAlgorithms: Optional[List[zio.aws.kms.model.MacAlgorithmSpec]]
    def getAwsAccountId: ZIO[Any, AwsError, AWSAccountIdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKeyUsage: ZIO[Any, AwsError, zio.aws.kms.model.KeyUsageType] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getKeyState: ZIO[Any, AwsError, zio.aws.kms.model.KeyState] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getDeletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getValidTo: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validTo", validTo)
    def getOrigin: ZIO[Any, AwsError, zio.aws.kms.model.OriginType] =
      AwsError.unwrapOptionField("origin", origin)
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getExpirationModel
        : ZIO[Any, AwsError, zio.aws.kms.model.ExpirationModelType] =
      AwsError.unwrapOptionField("expirationModel", expirationModel)
    def getKeyManager: ZIO[Any, AwsError, zio.aws.kms.model.KeyManagerType] =
      AwsError.unwrapOptionField("keyManager", keyManager)
    def getCustomerMasterKeySpec
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomerMasterKeySpec] =
      AwsError.unwrapOptionField("customerMasterKeySpec", customerMasterKeySpec)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.KeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getEncryptionAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.EncryptionAlgorithmSpec]] =
      AwsError.unwrapOptionField("encryptionAlgorithms", encryptionAlgorithms)
    def getSigningAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.SigningAlgorithmSpec]] =
      AwsError.unwrapOptionField("signingAlgorithms", signingAlgorithms)
    def getMultiRegion: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("multiRegion", multiRegion)
    def getMultiRegionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kms.model.MultiRegionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiRegionConfiguration",
      multiRegionConfiguration
    )
    def getPendingDeletionWindowInDays
        : ZIO[Any, AwsError, PendingWindowInDaysType] =
      AwsError.unwrapOptionField(
        "pendingDeletionWindowInDays",
        pendingDeletionWindowInDays
      )
    def getMacAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.MacAlgorithmSpec]] =
      AwsError.unwrapOptionField("macAlgorithms", macAlgorithms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.KeyMetadata
  ) extends zio.aws.kms.model.KeyMetadata.ReadOnly {
    override val awsAccountId: Optional[AWSAccountIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountId())
        .map(value => zio.aws.kms.model.primitives.AWSAccountIdType(value))
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.kms.model.primitives.ArnType(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val enabled: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val description: Optional[DescriptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kms.model.primitives.DescriptionType(value))
    override val keyUsage: Optional[zio.aws.kms.model.KeyUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsage())
        .map(value => zio.aws.kms.model.KeyUsageType.wrap(value))
    override val keyState: Optional[zio.aws.kms.model.KeyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyState())
        .map(value => zio.aws.kms.model.KeyState.wrap(value))
    override val deletionDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val validTo: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.validTo())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val origin: Optional[zio.aws.kms.model.OriginType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origin())
        .map(value => zio.aws.kms.model.OriginType.wrap(value))
    override val customKeyStoreId: Optional[CustomKeyStoreIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customKeyStoreId())
        .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val cloudHsmClusterId: Optional[CloudHsmClusterIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudHsmClusterId())
        .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val expirationModel
        : Optional[zio.aws.kms.model.ExpirationModelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationModel())
        .map(value => zio.aws.kms.model.ExpirationModelType.wrap(value))
    override val keyManager: Optional[zio.aws.kms.model.KeyManagerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyManager())
        .map(value => zio.aws.kms.model.KeyManagerType.wrap(value))
    override val customerMasterKeySpec
        : Optional[zio.aws.kms.model.CustomerMasterKeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerMasterKeySpec())
        .map(value => zio.aws.kms.model.CustomerMasterKeySpec.wrap(value))
    override val keySpec: Optional[zio.aws.kms.model.KeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySpec())
        .map(value => zio.aws.kms.model.KeySpec.wrap(value))
    override val encryptionAlgorithms
        : Optional[List[zio.aws.kms.model.EncryptionAlgorithmSpec]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(item)
          }.toList
        )
    override val signingAlgorithms
        : Optional[List[zio.aws.kms.model.SigningAlgorithmSpec]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.SigningAlgorithmSpec.wrap(item)
          }.toList
        )
    override val multiRegion: Optional[NullableBooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiRegion())
        .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
    override val multiRegionConfiguration
        : Optional[zio.aws.kms.model.MultiRegionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiRegionConfiguration())
        .map(value => zio.aws.kms.model.MultiRegionConfiguration.wrap(value))
    override val pendingDeletionWindowInDays
        : Optional[PendingWindowInDaysType] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingDeletionWindowInDays())
      .map(value => zio.aws.kms.model.primitives.PendingWindowInDaysType(value))
    override val macAlgorithms
        : Optional[List[zio.aws.kms.model.MacAlgorithmSpec]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.MacAlgorithmSpec.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.KeyMetadata
  ): zio.aws.kms.model.KeyMetadata.ReadOnly = new Wrapper(impl)
}
