package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  KeyStorePasswordType,
  TrustAnchorCertificateType,
  CloudHsmClusterIdType,
  CustomKeyStoreNameType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomKeyStoreRequest(
    customKeyStoreName: CustomKeyStoreNameType,
    cloudHsmClusterId: Optional[CloudHsmClusterIdType] = Optional.Absent,
    trustAnchorCertificate: Optional[TrustAnchorCertificateType] =
      Optional.Absent,
    keyStorePassword: Optional[KeyStorePasswordType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest = {
    import CreateCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
      .builder()
      .customKeyStoreName(
        CustomKeyStoreNameType.unwrap(customKeyStoreName): java.lang.String
      )
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(
        trustAnchorCertificate.map(value =>
          TrustAnchorCertificateType.unwrap(value): java.lang.String
        )
      )(_.trustAnchorCertificate)
      .optionallyWith(
        keyStorePassword.map(value =>
          KeyStorePasswordType.unwrap(value): java.lang.String
        )
      )(_.keyStorePassword)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.CreateCustomKeyStoreRequest.wrap(buildAwsValue())
}
object CreateCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateCustomKeyStoreRequest =
      zio.aws.kms.model.CreateCustomKeyStoreRequest(
        customKeyStoreName,
        cloudHsmClusterId.map(value => value),
        trustAnchorCertificate.map(value => value),
        keyStorePassword.map(value => value)
      )
    def customKeyStoreName: CustomKeyStoreNameType
    def cloudHsmClusterId: Optional[CloudHsmClusterIdType]
    def trustAnchorCertificate: Optional[TrustAnchorCertificateType]
    def keyStorePassword: Optional[KeyStorePasswordType]
    def getCustomKeyStoreName: ZIO[Any, Nothing, CustomKeyStoreNameType] =
      ZIO.succeed(customKeyStoreName)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getTrustAnchorCertificate
        : ZIO[Any, AwsError, TrustAnchorCertificateType] = AwsError
      .unwrapOptionField("trustAnchorCertificate", trustAnchorCertificate)
    def getKeyStorePassword: ZIO[Any, AwsError, KeyStorePasswordType] =
      AwsError.unwrapOptionField("keyStorePassword", keyStorePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ) extends zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreName: CustomKeyStoreNameType =
      zio.aws.kms.model.primitives
        .CustomKeyStoreNameType(impl.customKeyStoreName())
    override val cloudHsmClusterId: Optional[CloudHsmClusterIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudHsmClusterId())
        .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val trustAnchorCertificate: Optional[TrustAnchorCertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustAnchorCertificate())
        .map(value =>
          zio.aws.kms.model.primitives.TrustAnchorCertificateType(value)
        )
    override val keyStorePassword: Optional[KeyStorePasswordType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyStorePassword())
        .map(value => zio.aws.kms.model.primitives.KeyStorePasswordType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ): zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
