package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait DataKeyPairSpec {
  def unwrap: software.amazon.awssdk.services.kms.model.DataKeyPairSpec
}
object DataKeyPairSpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.DataKeyPairSpec
  ): zio.aws.kms.model.DataKeyPairSpec = value match {
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.RSA_2048 =>
      val r = RSA_2048
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.RSA_3072 =>
      val r = RSA_3072
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.RSA_4096 =>
      val r = RSA_4096
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_NIST_P256 =>
      val r = ECC_NIST_P256
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_NIST_P384 =>
      val r = ECC_NIST_P384
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_NIST_P521 =>
      val r = ECC_NIST_P521
      r
    case software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_SECG_P256_K1 =>
      val r = ECC_SECG_P256K1
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.UNKNOWN_TO_SDK_VERSION
  }
  case object RSA_2048 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.RSA_2048
  }
  case object RSA_3072 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.RSA_3072
  }
  case object RSA_4096 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.RSA_4096
  }
  case object ECC_NIST_P256 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_NIST_P256
  }
  case object ECC_NIST_P384 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_NIST_P384
  }
  case object ECC_NIST_P521 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_NIST_P521
  }
  case object ECC_SECG_P256K1 extends zio.aws.kms.model.DataKeyPairSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.DataKeyPairSpec =
      software.amazon.awssdk.services.kms.model.DataKeyPairSpec.ECC_SECG_P256_K1
  }
}
