package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait KeyUsageType {
  def unwrap: software.amazon.awssdk.services.kms.model.KeyUsageType
}
object KeyUsageType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.KeyUsageType
  ): zio.aws.kms.model.KeyUsageType = value match {
    case software.amazon.awssdk.services.kms.model.KeyUsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.KeyUsageType.SIGN_VERIFY =>
      val r = SIGN_VERIFY
      r
    case software.amazon.awssdk.services.kms.model.KeyUsageType.ENCRYPT_DECRYPT =>
      val r = ENCRYPT_DECRYPT
      r
    case software.amazon.awssdk.services.kms.model.KeyUsageType.GENERATE_VERIFY_MAC =>
      val r = GENERATE_VERIFY_MAC
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.KeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyUsageType =
      software.amazon.awssdk.services.kms.model.KeyUsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIGN_VERIFY extends zio.aws.kms.model.KeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyUsageType =
      software.amazon.awssdk.services.kms.model.KeyUsageType.SIGN_VERIFY
  }
  case object ENCRYPT_DECRYPT extends zio.aws.kms.model.KeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyUsageType =
      software.amazon.awssdk.services.kms.model.KeyUsageType.ENCRYPT_DECRYPT
  }
  case object GENERATE_VERIFY_MAC extends zio.aws.kms.model.KeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyUsageType =
      software.amazon.awssdk.services.kms.model.KeyUsageType.GENERATE_VERIFY_MAC
  }
}
