package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, PublicKeyType, CiphertextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyPairWithoutPlaintextResponse(
    privateKeyCiphertextBlob: Optional[CiphertextType] = Optional.Absent,
    publicKey: Optional[PublicKeyType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent,
    keyPairSpec: Optional[zio.aws.kms.model.DataKeyPairSpec] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse = {
    import GenerateDataKeyPairWithoutPlaintextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
      .builder()
      .optionallyWith(
        privateKeyCiphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.privateKeyCiphertextBlob)
      .optionallyWith(
        publicKey.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.publicKey)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(keyPairSpec.map(value => value.unwrap))(_.keyPairSpec)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
      .wrap(buildAwsValue())
}
object GenerateDataKeyPairWithoutPlaintextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse =
      zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse(
        privateKeyCiphertextBlob.map(value => value),
        publicKey.map(value => value),
        keyId.map(value => value),
        keyPairSpec.map(value => value)
      )
    def privateKeyCiphertextBlob: Optional[CiphertextType]
    def publicKey: Optional[PublicKeyType]
    def keyId: Optional[KeyIdType]
    def keyPairSpec: Optional[zio.aws.kms.model.DataKeyPairSpec]
    def getPrivateKeyCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField(
        "privateKeyCiphertextBlob",
        privateKeyCiphertextBlob
      )
    def getPublicKey: ZIO[Any, AwsError, PublicKeyType] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getKeyPairSpec: ZIO[Any, AwsError, zio.aws.kms.model.DataKeyPairSpec] =
      AwsError.unwrapOptionField("keyPairSpec", keyPairSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
  ) extends zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly {
    override val privateKeyCiphertextBlob: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateKeyCiphertextBlob())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val publicKey: Optional[PublicKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKey())
      .map(value =>
        zio.aws.kms.model.primitives
          .PublicKeyType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val keyPairSpec: Optional[zio.aws.kms.model.DataKeyPairSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPairSpec())
        .map(value => zio.aws.kms.model.DataKeyPairSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
  ): zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly =
    new Wrapper(impl)
}
