package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  BooleanType,
  CustomKeyStoreIdType,
  DescriptionType,
  NullableBooleanType,
  PolicyType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyRequest(
    policy: Optional[PolicyType] = Optional.Absent,
    description: Optional[DescriptionType] = Optional.Absent,
    keyUsage: Optional[zio.aws.kms.model.KeyUsageType] = Optional.Absent,
    customerMasterKeySpec: Optional[zio.aws.kms.model.CustomerMasterKeySpec] =
      Optional.Absent,
    keySpec: Optional[zio.aws.kms.model.KeySpec] = Optional.Absent,
    origin: Optional[zio.aws.kms.model.OriginType] = Optional.Absent,
    customKeyStoreId: Optional[CustomKeyStoreIdType] = Optional.Absent,
    bypassPolicyLockoutSafetyCheck: Optional[BooleanType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.kms.model.Tag]] = Optional.Absent,
    multiRegion: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateKeyRequest = {
    import CreateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateKeyRequest
      .builder()
      .optionallyWith(
        policy.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(keyUsage.map(value => value.unwrap))(_.keyUsage)
      .optionallyWith(customerMasterKeySpec.map(value => value.unwrap))(
        _.customerMasterKeySpec
      )
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        bypassPolicyLockoutSafetyCheck.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.bypassPolicyLockoutSafetyCheck)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        multiRegion.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.multiRegion)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateKeyRequest.ReadOnly =
    zio.aws.kms.model.CreateKeyRequest.wrap(buildAwsValue())
}
object CreateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateKeyRequest =
      zio.aws.kms.model.CreateKeyRequest(
        policy.map(value => value),
        description.map(value => value),
        keyUsage.map(value => value),
        customerMasterKeySpec.map(value => value),
        keySpec.map(value => value),
        origin.map(value => value),
        customKeyStoreId.map(value => value),
        bypassPolicyLockoutSafetyCheck.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiRegion.map(value => value)
      )
    def policy: Optional[PolicyType]
    def description: Optional[DescriptionType]
    def keyUsage: Optional[zio.aws.kms.model.KeyUsageType]
    def customerMasterKeySpec: Optional[zio.aws.kms.model.CustomerMasterKeySpec]
    def keySpec: Optional[zio.aws.kms.model.KeySpec]
    def origin: Optional[zio.aws.kms.model.OriginType]
    def customKeyStoreId: Optional[CustomKeyStoreIdType]
    def bypassPolicyLockoutSafetyCheck: Optional[BooleanType]
    def tags: Optional[List[zio.aws.kms.model.Tag.ReadOnly]]
    def multiRegion: Optional[NullableBooleanType]
    def getPolicy: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("policy", policy)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKeyUsage: ZIO[Any, AwsError, zio.aws.kms.model.KeyUsageType] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getCustomerMasterKeySpec
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomerMasterKeySpec] =
      AwsError.unwrapOptionField("customerMasterKeySpec", customerMasterKeySpec)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.KeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getOrigin: ZIO[Any, AwsError, zio.aws.kms.model.OriginType] =
      AwsError.unwrapOptionField("origin", origin)
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getBypassPolicyLockoutSafetyCheck: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "bypassPolicyLockoutSafetyCheck",
        bypassPolicyLockoutSafetyCheck
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMultiRegion: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("multiRegion", multiRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateKeyRequest
  ) extends zio.aws.kms.model.CreateKeyRequest.ReadOnly {
    override val policy: Optional[PolicyType] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.kms.model.primitives.PolicyType(value))
    override val description: Optional[DescriptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kms.model.primitives.DescriptionType(value))
    override val keyUsage: Optional[zio.aws.kms.model.KeyUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsage())
        .map(value => zio.aws.kms.model.KeyUsageType.wrap(value))
    override val customerMasterKeySpec
        : Optional[zio.aws.kms.model.CustomerMasterKeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerMasterKeySpec())
        .map(value => zio.aws.kms.model.CustomerMasterKeySpec.wrap(value))
    override val keySpec: Optional[zio.aws.kms.model.KeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySpec())
        .map(value => zio.aws.kms.model.KeySpec.wrap(value))
    override val origin: Optional[zio.aws.kms.model.OriginType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origin())
        .map(value => zio.aws.kms.model.OriginType.wrap(value))
    override val customKeyStoreId: Optional[CustomKeyStoreIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customKeyStoreId())
        .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val bypassPolicyLockoutSafetyCheck: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bypassPolicyLockoutSafetyCheck())
        .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val tags: Optional[List[zio.aws.kms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.Tag.wrap(item)
          }.toList
        )
    override val multiRegion: Optional[NullableBooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiRegion())
        .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateKeyRequest
  ): zio.aws.kms.model.CreateKeyRequest.ReadOnly = new Wrapper(impl)
}
