package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionStateType {
  def unwrap: software.amazon.awssdk.services.kms.model.ConnectionStateType
}
object ConnectionStateType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.ConnectionStateType
  ): zio.aws.kms.model.ConnectionStateType = value match {
    case software.amazon.awssdk.services.kms.model.ConnectionStateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.ConnectionStateType.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.kms.model.ConnectionStateType.CONNECTING =>
      val r = CONNECTING
      r
    case software.amazon.awssdk.services.kms.model.ConnectionStateType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kms.model.ConnectionStateType.DISCONNECTED =>
      val r = DISCONNECTED
      r
    case software.amazon.awssdk.services.kms.model.ConnectionStateType.DISCONNECTING =>
      val r = DISCONNECTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.ConnectionStateType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionStateType =
      software.amazon.awssdk.services.kms.model.ConnectionStateType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED extends zio.aws.kms.model.ConnectionStateType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionStateType =
      software.amazon.awssdk.services.kms.model.ConnectionStateType.CONNECTED
  }
  case object CONNECTING extends zio.aws.kms.model.ConnectionStateType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionStateType =
      software.amazon.awssdk.services.kms.model.ConnectionStateType.CONNECTING
  }
  case object FAILED extends zio.aws.kms.model.ConnectionStateType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionStateType =
      software.amazon.awssdk.services.kms.model.ConnectionStateType.FAILED
  }
  case object DISCONNECTED extends zio.aws.kms.model.ConnectionStateType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionStateType =
      software.amazon.awssdk.services.kms.model.ConnectionStateType.DISCONNECTED
  }
  case object DISCONNECTING extends zio.aws.kms.model.ConnectionStateType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionStateType =
      software.amazon.awssdk.services.kms.model.ConnectionStateType.DISCONNECTING
  }
}
