package zio.aws.kms
import zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.kms.model.primitives.PolicyNameType
import zio.aws.kms.model.{
  GetParametersForImportRequest,
  ConnectCustomKeyStoreRequest,
  ListRetirableGrantsRequest,
  RetireGrantRequest,
  ListKeyPoliciesRequest,
  DisconnectCustomKeyStoreRequest,
  UpdateCustomKeyStoreRequest,
  UpdateAliasRequest,
  DeleteImportedKeyMaterialRequest,
  PutKeyPolicyRequest,
  EnableKeyRequest,
  GenerateDataKeyRequest,
  RevokeGrantRequest,
  CreateKeyRequest,
  CreateAliasRequest,
  ListGrantsRequest,
  EncryptRequest,
  DeleteCustomKeyStoreRequest,
  UpdateKeyDescriptionRequest,
  DeleteAliasRequest,
  ListAliasesRequest,
  DisableKeyRotationRequest,
  GenerateRandomRequest,
  GenerateDataKeyWithoutPlaintextRequest,
  GetKeyRotationStatusRequest,
  DescribeKeyRequest,
  EnableKeyRotationRequest,
  CreateGrantRequest,
  ReEncryptRequest,
  ListResourceTagsRequest,
  SignRequest,
  DescribeCustomKeyStoresRequest,
  VerifyRequest,
  CreateCustomKeyStoreRequest,
  UntagResourceRequest,
  UpdatePrimaryRegionRequest,
  DisableKeyRequest,
  ScheduleKeyDeletionRequest,
  DecryptRequest,
  GenerateDataKeyPairWithoutPlaintextRequest,
  GenerateDataKeyPairRequest,
  ListKeysRequest,
  GetPublicKeyRequest,
  CancelKeyDeletionRequest,
  ImportKeyMaterialRequest,
  TagResourceRequest,
  GetKeyPolicyRequest,
  ReplicateKeyRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.kms.KmsAsyncClient
import zio.stream.ZStream
object KmsMock extends Mock[Kms] {
  object DeleteImportedKeyMaterial
      extends Effect[DeleteImportedKeyMaterialRequest, AwsError, Unit]
  object PutKeyPolicy extends Effect[PutKeyPolicyRequest, AwsError, Unit]
  object DescribeCustomKeyStores
      extends Effect[
        DescribeCustomKeyStoresRequest,
        AwsError,
        zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly
      ]
  object ImportKeyMaterial
      extends Effect[
        ImportKeyMaterialRequest,
        AwsError,
        zio.aws.kms.model.ImportKeyMaterialResponse.ReadOnly
      ]
  object GenerateDataKeyWithoutPlaintext
      extends Effect[GenerateDataKeyWithoutPlaintextRequest, AwsError, ReadOnly]
  object ScheduleKeyDeletion
      extends Effect[
        ScheduleKeyDeletionRequest,
        AwsError,
        zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly
      ]
  object ListRetirableGrants
      extends Effect[
        ListRetirableGrantsRequest,
        AwsError,
        zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly
      ]
  object DeleteCustomKeyStore
      extends Effect[
        DeleteCustomKeyStoreRequest,
        AwsError,
        zio.aws.kms.model.DeleteCustomKeyStoreResponse.ReadOnly
      ]
  object ReplicateKey
      extends Effect[
        ReplicateKeyRequest,
        AwsError,
        zio.aws.kms.model.ReplicateKeyResponse.ReadOnly
      ]
  object RevokeGrant extends Effect[RevokeGrantRequest, AwsError, Unit]
  object EnableKeyRotation
      extends Effect[EnableKeyRotationRequest, AwsError, Unit]
  object CreateGrant
      extends Effect[
        CreateGrantRequest,
        AwsError,
        zio.aws.kms.model.CreateGrantResponse.ReadOnly
      ]
  object CancelKeyDeletion
      extends Effect[
        CancelKeyDeletionRequest,
        AwsError,
        zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly
      ]
  object Decrypt
      extends Effect[
        DecryptRequest,
        AwsError,
        zio.aws.kms.model.DecryptResponse.ReadOnly
      ]
  object GenerateDataKeyPair
      extends Effect[
        GenerateDataKeyPairRequest,
        AwsError,
        zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly
      ]
  object Verify
      extends Effect[
        VerifyRequest,
        AwsError,
        zio.aws.kms.model.VerifyResponse.ReadOnly
      ]
  object ConnectCustomKeyStore
      extends Effect[
        ConnectCustomKeyStoreRequest,
        AwsError,
        zio.aws.kms.model.ConnectCustomKeyStoreResponse.ReadOnly
      ]
  object Sign
      extends Effect[
        SignRequest,
        AwsError,
        zio.aws.kms.model.SignResponse.ReadOnly
      ]
  object GetPublicKey
      extends Effect[
        GetPublicKeyRequest,
        AwsError,
        zio.aws.kms.model.GetPublicKeyResponse.ReadOnly
      ]
  object UpdateKeyDescription
      extends Effect[UpdateKeyDescriptionRequest, AwsError, Unit]
  object ReEncrypt
      extends Effect[
        ReEncryptRequest,
        AwsError,
        zio.aws.kms.model.ReEncryptResponse.ReadOnly
      ]
  object GenerateDataKeyPairWithoutPlaintext
      extends Effect[
        GenerateDataKeyPairWithoutPlaintextRequest,
        AwsError,
        zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly
      ]
  object GetKeyRotationStatus
      extends Effect[
        GetKeyRotationStatusRequest,
        AwsError,
        zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly
      ]
  object ListAliases
      extends Stream[
        ListAliasesRequest,
        AwsError,
        zio.aws.kms.model.AliasListEntry.ReadOnly
      ]
  object ListAliasesPaginated
      extends Effect[
        ListAliasesRequest,
        AwsError,
        zio.aws.kms.model.ListAliasesResponse.ReadOnly
      ]
  object GetParametersForImport
      extends Effect[
        GetParametersForImportRequest,
        AwsError,
        zio.aws.kms.model.GetParametersForImportResponse.ReadOnly
      ]
  object Encrypt
      extends Effect[
        EncryptRequest,
        AwsError,
        zio.aws.kms.model.EncryptResponse.ReadOnly
      ]
  object UpdateAlias extends Effect[UpdateAliasRequest, AwsError, Unit]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object CreateAlias extends Effect[CreateAliasRequest, AwsError, Unit]
  object DisconnectCustomKeyStore
      extends Effect[
        DisconnectCustomKeyStoreRequest,
        AwsError,
        zio.aws.kms.model.DisconnectCustomKeyStoreResponse.ReadOnly
      ]
  object DisableKey extends Effect[DisableKeyRequest, AwsError, Unit]
  object GenerateRandom
      extends Effect[
        GenerateRandomRequest,
        AwsError,
        zio.aws.kms.model.GenerateRandomResponse.ReadOnly
      ]
  object ListGrants
      extends Stream[
        ListGrantsRequest,
        AwsError,
        zio.aws.kms.model.GrantListEntry.ReadOnly
      ]
  object ListGrantsPaginated
      extends Effect[
        ListGrantsRequest,
        AwsError,
        zio.aws.kms.model.ListGrantsResponse.ReadOnly
      ]
  object UpdatePrimaryRegion
      extends Effect[UpdatePrimaryRegionRequest, AwsError, Unit]
  object CreateKey
      extends Effect[
        CreateKeyRequest,
        AwsError,
        zio.aws.kms.model.CreateKeyResponse.ReadOnly
      ]
  object EnableKey extends Effect[EnableKeyRequest, AwsError, Unit]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DeleteAlias extends Effect[DeleteAliasRequest, AwsError, Unit]
  object GetKeyPolicy
      extends Effect[
        GetKeyPolicyRequest,
        AwsError,
        zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly
      ]
  object ListKeyPolicies
      extends Stream[ListKeyPoliciesRequest, AwsError, PolicyNameType]
  object ListKeyPoliciesPaginated
      extends Effect[
        ListKeyPoliciesRequest,
        AwsError,
        zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly
      ]
  object DisableKeyRotation
      extends Effect[DisableKeyRotationRequest, AwsError, Unit]
  object GenerateDataKey
      extends Effect[
        GenerateDataKeyRequest,
        AwsError,
        zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly
      ]
  object UpdateCustomKeyStore
      extends Effect[
        UpdateCustomKeyStoreRequest,
        AwsError,
        zio.aws.kms.model.UpdateCustomKeyStoreResponse.ReadOnly
      ]
  object RetireGrant extends Effect[RetireGrantRequest, AwsError, Unit]
  object CreateCustomKeyStore
      extends Effect[
        CreateCustomKeyStoreRequest,
        AwsError,
        zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly
      ]
  object ListResourceTags
      extends Effect[
        ListResourceTagsRequest,
        AwsError,
        zio.aws.kms.model.ListResourceTagsResponse.ReadOnly
      ]
  object DescribeKey
      extends Effect[
        DescribeKeyRequest,
        AwsError,
        zio.aws.kms.model.DescribeKeyResponse.ReadOnly
      ]
  object ListKeys
      extends Stream[
        ListKeysRequest,
        AwsError,
        zio.aws.kms.model.KeyListEntry.ReadOnly
      ]
  object ListKeysPaginated
      extends Effect[
        ListKeysRequest,
        AwsError,
        zio.aws.kms.model.ListKeysResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Kms] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Kms {
          val api: KmsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Kms = this
          def deleteImportedKeyMaterial(
              request: DeleteImportedKeyMaterialRequest
          ): IO[AwsError, Unit] = proxy(DeleteImportedKeyMaterial, request)
          def putKeyPolicy(request: PutKeyPolicyRequest): IO[AwsError, Unit] =
            proxy(PutKeyPolicy, request)
          def describeCustomKeyStores(
              request: DescribeCustomKeyStoresRequest
          ): IO[
            AwsError,
            zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly
          ] = proxy(DescribeCustomKeyStores, request)
          def importKeyMaterial(request: ImportKeyMaterialRequest): IO[
            AwsError,
            zio.aws.kms.model.ImportKeyMaterialResponse.ReadOnly
          ] = proxy(ImportKeyMaterial, request)
          def generateDataKeyWithoutPlaintext(
              request: GenerateDataKeyWithoutPlaintextRequest
          ): IO[AwsError, ReadOnly] =
            proxy(GenerateDataKeyWithoutPlaintext, request)
          def scheduleKeyDeletion(request: ScheduleKeyDeletionRequest): IO[
            AwsError,
            zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly
          ] = proxy(ScheduleKeyDeletion, request)
          def listRetirableGrants(request: ListRetirableGrantsRequest): IO[
            AwsError,
            zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly
          ] = proxy(ListRetirableGrants, request)
          def deleteCustomKeyStore(request: DeleteCustomKeyStoreRequest): IO[
            AwsError,
            zio.aws.kms.model.DeleteCustomKeyStoreResponse.ReadOnly
          ] = proxy(DeleteCustomKeyStore, request)
          def replicateKey(
              request: ReplicateKeyRequest
          ): IO[AwsError, zio.aws.kms.model.ReplicateKeyResponse.ReadOnly] =
            proxy(ReplicateKey, request)
          def revokeGrant(request: RevokeGrantRequest): IO[AwsError, Unit] =
            proxy(RevokeGrant, request)
          def enableKeyRotation(
              request: EnableKeyRotationRequest
          ): IO[AwsError, Unit] = proxy(EnableKeyRotation, request)
          def createGrant(
              request: CreateGrantRequest
          ): IO[AwsError, zio.aws.kms.model.CreateGrantResponse.ReadOnly] =
            proxy(CreateGrant, request)
          def cancelKeyDeletion(request: CancelKeyDeletionRequest): IO[
            AwsError,
            zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly
          ] = proxy(CancelKeyDeletion, request)
          def decrypt(
              request: DecryptRequest
          ): IO[AwsError, zio.aws.kms.model.DecryptResponse.ReadOnly] =
            proxy(Decrypt, request)
          def generateDataKeyPair(request: GenerateDataKeyPairRequest): IO[
            AwsError,
            zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly
          ] = proxy(GenerateDataKeyPair, request)
          def verify(
              request: VerifyRequest
          ): IO[AwsError, zio.aws.kms.model.VerifyResponse.ReadOnly] =
            proxy(Verify, request)
          def connectCustomKeyStore(request: ConnectCustomKeyStoreRequest): IO[
            AwsError,
            zio.aws.kms.model.ConnectCustomKeyStoreResponse.ReadOnly
          ] = proxy(ConnectCustomKeyStore, request)
          def sign(
              request: SignRequest
          ): IO[AwsError, zio.aws.kms.model.SignResponse.ReadOnly] =
            proxy(Sign, request)
          def getPublicKey(
              request: GetPublicKeyRequest
          ): IO[AwsError, zio.aws.kms.model.GetPublicKeyResponse.ReadOnly] =
            proxy(GetPublicKey, request)
          def updateKeyDescription(
              request: UpdateKeyDescriptionRequest
          ): IO[AwsError, Unit] = proxy(UpdateKeyDescription, request)
          def reEncrypt(
              request: ReEncryptRequest
          ): IO[AwsError, zio.aws.kms.model.ReEncryptResponse.ReadOnly] =
            proxy(ReEncrypt, request)
          def generateDataKeyPairWithoutPlaintext(
              request: GenerateDataKeyPairWithoutPlaintextRequest
          ): IO[
            AwsError,
            zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly
          ] = proxy(GenerateDataKeyPairWithoutPlaintext, request)
          def getKeyRotationStatus(request: GetKeyRotationStatusRequest): IO[
            AwsError,
            zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly
          ] = proxy(GetKeyRotationStatus, request)
          def listAliases(
              request: ListAliasesRequest
          ): ZStream[Any, AwsError, zio.aws.kms.model.AliasListEntry.ReadOnly] =
            rts.unsafeRun(proxy(ListAliases, request))
          def listAliasesPaginated(
              request: ListAliasesRequest
          ): IO[AwsError, zio.aws.kms.model.ListAliasesResponse.ReadOnly] =
            proxy(ListAliasesPaginated, request)
          def getParametersForImport(
              request: GetParametersForImportRequest
          ): IO[
            AwsError,
            zio.aws.kms.model.GetParametersForImportResponse.ReadOnly
          ] = proxy(GetParametersForImport, request)
          def encrypt(
              request: EncryptRequest
          ): IO[AwsError, zio.aws.kms.model.EncryptResponse.ReadOnly] =
            proxy(Encrypt, request)
          def updateAlias(request: UpdateAliasRequest): IO[AwsError, Unit] =
            proxy(UpdateAlias, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def createAlias(request: CreateAliasRequest): IO[AwsError, Unit] =
            proxy(CreateAlias, request)
          def disconnectCustomKeyStore(
              request: DisconnectCustomKeyStoreRequest
          ): IO[
            AwsError,
            zio.aws.kms.model.DisconnectCustomKeyStoreResponse.ReadOnly
          ] = proxy(DisconnectCustomKeyStore, request)
          def disableKey(request: DisableKeyRequest): IO[AwsError, Unit] =
            proxy(DisableKey, request)
          def generateRandom(
              request: GenerateRandomRequest
          ): IO[AwsError, zio.aws.kms.model.GenerateRandomResponse.ReadOnly] =
            proxy(GenerateRandom, request)
          def listGrants(
              request: ListGrantsRequest
          ): ZStream[Any, AwsError, zio.aws.kms.model.GrantListEntry.ReadOnly] =
            rts.unsafeRun(proxy(ListGrants, request))
          def listGrantsPaginated(
              request: ListGrantsRequest
          ): IO[AwsError, zio.aws.kms.model.ListGrantsResponse.ReadOnly] =
            proxy(ListGrantsPaginated, request)
          def updatePrimaryRegion(
              request: UpdatePrimaryRegionRequest
          ): IO[AwsError, Unit] = proxy(UpdatePrimaryRegion, request)
          def createKey(
              request: CreateKeyRequest
          ): IO[AwsError, zio.aws.kms.model.CreateKeyResponse.ReadOnly] =
            proxy(CreateKey, request)
          def enableKey(request: EnableKeyRequest): IO[AwsError, Unit] =
            proxy(EnableKey, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit] =
            proxy(DeleteAlias, request)
          def getKeyPolicy(
              request: GetKeyPolicyRequest
          ): IO[AwsError, zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly] =
            proxy(GetKeyPolicy, request)
          def listKeyPolicies(
              request: ListKeyPoliciesRequest
          ): ZStream[Any, AwsError, PolicyNameType] =
            rts.unsafeRun(proxy(ListKeyPolicies, request))
          def listKeyPoliciesPaginated(
              request: ListKeyPoliciesRequest
          ): IO[AwsError, zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly] =
            proxy(ListKeyPoliciesPaginated, request)
          def disableKeyRotation(
              request: DisableKeyRotationRequest
          ): IO[AwsError, Unit] = proxy(DisableKeyRotation, request)
          def generateDataKey(
              request: GenerateDataKeyRequest
          ): IO[AwsError, zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly] =
            proxy(GenerateDataKey, request)
          def updateCustomKeyStore(request: UpdateCustomKeyStoreRequest): IO[
            AwsError,
            zio.aws.kms.model.UpdateCustomKeyStoreResponse.ReadOnly
          ] = proxy(UpdateCustomKeyStore, request)
          def retireGrant(request: RetireGrantRequest): IO[AwsError, Unit] =
            proxy(RetireGrant, request)
          def createCustomKeyStore(request: CreateCustomKeyStoreRequest): IO[
            AwsError,
            zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly
          ] = proxy(CreateCustomKeyStore, request)
          def listResourceTags(
              request: ListResourceTagsRequest
          ): IO[AwsError, zio.aws.kms.model.ListResourceTagsResponse.ReadOnly] =
            proxy(ListResourceTags, request)
          def describeKey(
              request: DescribeKeyRequest
          ): IO[AwsError, zio.aws.kms.model.DescribeKeyResponse.ReadOnly] =
            proxy(DescribeKey, request)
          def listKeys(
              request: ListKeysRequest
          ): ZStream[Any, AwsError, zio.aws.kms.model.KeyListEntry.ReadOnly] =
            rts.unsafeRun(proxy(ListKeys, request))
          def listKeysPaginated(
              request: ListKeysRequest
          ): IO[AwsError, zio.aws.kms.model.ListKeysResponse.ReadOnly] =
            proxy(ListKeysPaginated, request)
        }
      }
    }
  }
}
