package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{PendingWindowInDaysType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class ScheduleKeyDeletionRequest(
    keyId: KeyIdType,
    pendingWindowInDays: Option[PendingWindowInDaysType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest = {
    import ScheduleKeyDeletionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        pendingWindowInDays.map(value =>
          PendingWindowInDaysType.unwrap(value): Integer
        )
      )(_.pendingWindowInDays)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ScheduleKeyDeletionRequest.ReadOnly =
    zio.aws.kms.model.ScheduleKeyDeletionRequest.wrap(buildAwsValue())
}
object ScheduleKeyDeletionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ScheduleKeyDeletionRequest =
      zio.aws.kms.model.ScheduleKeyDeletionRequest(
        keyId,
        pendingWindowInDays.map(value => value)
      )
    def keyId: KeyIdType
    def pendingWindowInDays: Option[PendingWindowInDaysType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getPendingWindowInDays: ZIO[Any, AwsError, PendingWindowInDaysType] =
      AwsError.unwrapOptionField("pendingWindowInDays", pendingWindowInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest
  ) extends zio.aws.kms.model.ScheduleKeyDeletionRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val pendingWindowInDays: Option[PendingWindowInDaysType] = scala
      .Option(impl.pendingWindowInDays())
      .map(value => zio.aws.kms.model.primitives.PendingWindowInDaysType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest
  ): zio.aws.kms.model.ScheduleKeyDeletionRequest.ReadOnly = new Wrapper(impl)
}
