package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters._
final case class GetParametersForImportRequest(
    keyId: KeyIdType,
    wrappingAlgorithm: zio.aws.kms.model.AlgorithmSpec,
    wrappingKeySpec: zio.aws.kms.model.WrappingKeySpec
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetParametersForImportRequest = {
    import GetParametersForImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetParametersForImportRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .wrappingAlgorithm(wrappingAlgorithm.unwrap)
      .wrappingKeySpec(wrappingKeySpec.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetParametersForImportRequest.ReadOnly =
    zio.aws.kms.model.GetParametersForImportRequest.wrap(buildAwsValue())
}
object GetParametersForImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetParametersForImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetParametersForImportRequest =
      zio.aws.kms.model.GetParametersForImportRequest(
        keyId,
        wrappingAlgorithm,
        wrappingKeySpec
      )
    def keyId: KeyIdType
    def wrappingAlgorithm: zio.aws.kms.model.AlgorithmSpec
    def wrappingKeySpec: zio.aws.kms.model.WrappingKeySpec
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getWrappingAlgorithm
        : ZIO[Any, Nothing, zio.aws.kms.model.AlgorithmSpec] =
      ZIO.succeed(wrappingAlgorithm)
    def getWrappingKeySpec
        : ZIO[Any, Nothing, zio.aws.kms.model.WrappingKeySpec] =
      ZIO.succeed(wrappingKeySpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetParametersForImportRequest
  ) extends zio.aws.kms.model.GetParametersForImportRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val wrappingAlgorithm: zio.aws.kms.model.AlgorithmSpec =
      zio.aws.kms.model.AlgorithmSpec.wrap(impl.wrappingAlgorithm())
    override val wrappingKeySpec: zio.aws.kms.model.WrappingKeySpec =
      zio.aws.kms.model.WrappingKeySpec.wrap(impl.wrappingKeySpec())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetParametersForImportRequest
  ): zio.aws.kms.model.GetParametersForImportRequest.ReadOnly = new Wrapper(
    impl
  )
}
