package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  NumberOfBytesType,
  EncryptionContextKey
}
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyWithoutPlaintextRequest(
    keyId: KeyIdType,
    encryptionContext: Option[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = None,
    keySpec: Option[zio.aws.kms.model.DataKeySpec] = None,
    numberOfBytes: Option[NumberOfBytesType] = None,
    grantTokens: Option[Iterable[GrantTokenType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest = {
    import GenerateDataKeyWithoutPlaintextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(
        numberOfBytes.map(value => NumberOfBytesType.unwrap(value): Integer)
      )(_.numberOfBytes)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest
      .wrap(buildAwsValue())
}
object GenerateDataKeyWithoutPlaintextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest =
      zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest(
        keyId,
        encryptionContext.map(value => value),
        keySpec.map(value => value),
        numberOfBytes.map(value => value),
        grantTokens.map(value => value)
      )
    def keyId: KeyIdType
    def encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]]
    def keySpec: Option[zio.aws.kms.model.DataKeySpec]
    def numberOfBytes: Option[NumberOfBytesType]
    def grantTokens: Option[List[GrantTokenType]]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.DataKeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getNumberOfBytes: ZIO[Any, AwsError, NumberOfBytesType] =
      AwsError.unwrapOptionField("numberOfBytes", numberOfBytes)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
  ) extends zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]] = scala
      .Option(impl.encryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kms.model.primitives.EncryptionContextKey(
              key
            ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
          })
          .toMap
      )
    override val keySpec: Option[zio.aws.kms.model.DataKeySpec] = scala
      .Option(impl.keySpec())
      .map(value => zio.aws.kms.model.DataKeySpec.wrap(value))
    override val numberOfBytes: Option[NumberOfBytesType] = scala
      .Option(impl.numberOfBytes())
      .map(value => zio.aws.kms.model.primitives.NumberOfBytesType(value))
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
  ): zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest.ReadOnly =
    new Wrapper(impl)
}
