package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  KeyIdType,
  BooleanType,
  RegionType,
  DescriptionType,
  PolicyType
}
import scala.jdk.CollectionConverters._
final case class ReplicateKeyRequest(
    keyId: KeyIdType,
    replicaRegion: RegionType,
    policy: Option[PolicyType] = None,
    bypassPolicyLockoutSafetyCheck: Option[BooleanType] = None,
    description: Option[DescriptionType] = None,
    tags: Option[Iterable[zio.aws.kms.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ReplicateKeyRequest = {
    import ReplicateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .replicaRegion(RegionType.unwrap(replicaRegion): java.lang.String)
      .optionallyWith(
        policy.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        bypassPolicyLockoutSafetyCheck.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.bypassPolicyLockoutSafetyCheck)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ReplicateKeyRequest.ReadOnly =
    zio.aws.kms.model.ReplicateKeyRequest.wrap(buildAwsValue())
}
object ReplicateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ReplicateKeyRequest =
      zio.aws.kms.model.ReplicateKeyRequest(
        keyId,
        replicaRegion,
        policy.map(value => value),
        bypassPolicyLockoutSafetyCheck.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyId: KeyIdType
    def replicaRegion: RegionType
    def policy: Option[PolicyType]
    def bypassPolicyLockoutSafetyCheck: Option[BooleanType]
    def description: Option[DescriptionType]
    def tags: Option[List[zio.aws.kms.model.Tag.ReadOnly]]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getReplicaRegion: ZIO[Any, Nothing, RegionType] =
      ZIO.succeed(replicaRegion)
    def getPolicy: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("policy", policy)
    def getBypassPolicyLockoutSafetyCheck: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "bypassPolicyLockoutSafetyCheck",
        bypassPolicyLockoutSafetyCheck
      )
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
  ) extends zio.aws.kms.model.ReplicateKeyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val replicaRegion: RegionType =
      zio.aws.kms.model.primitives.RegionType(impl.replicaRegion())
    override val policy: Option[PolicyType] = scala
      .Option(impl.policy())
      .map(value => zio.aws.kms.model.primitives.PolicyType(value))
    override val bypassPolicyLockoutSafetyCheck: Option[BooleanType] = scala
      .Option(impl.bypassPolicyLockoutSafetyCheck())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.kms.model.primitives.DescriptionType(value))
    override val tags: Option[List[zio.aws.kms.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
  ): zio.aws.kms.model.ReplicateKeyRequest.ReadOnly = new Wrapper(impl)
}
