package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{RegionType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class UpdatePrimaryRegionRequest(
    keyId: KeyIdType,
    primaryRegion: RegionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest = {
    import UpdatePrimaryRegionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .primaryRegion(RegionType.unwrap(primaryRegion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.UpdatePrimaryRegionRequest.ReadOnly =
    zio.aws.kms.model.UpdatePrimaryRegionRequest.wrap(buildAwsValue())
}
object UpdatePrimaryRegionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.UpdatePrimaryRegionRequest =
      zio.aws.kms.model.UpdatePrimaryRegionRequest(keyId, primaryRegion)
    def keyId: KeyIdType
    def primaryRegion: RegionType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getPrimaryRegion: ZIO[Any, Nothing, RegionType] =
      ZIO.succeed(primaryRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest
  ) extends zio.aws.kms.model.UpdatePrimaryRegionRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val primaryRegion: RegionType =
      zio.aws.kms.model.primitives.RegionType(impl.primaryRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest
  ): zio.aws.kms.model.UpdatePrimaryRegionRequest.ReadOnly = new Wrapper(impl)
}
