package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait OriginType {
  def unwrap: software.amazon.awssdk.services.kms.model.OriginType
}
object OriginType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.OriginType
  ): zio.aws.kms.model.OriginType = value match {
    case software.amazon.awssdk.services.kms.model.OriginType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.OriginType.AWS_KMS =>
      val r = AWS_KMS
      r
    case software.amazon.awssdk.services.kms.model.OriginType.EXTERNAL =>
      val r = EXTERNAL
      r
    case software.amazon.awssdk.services.kms.model.OriginType.AWS_CLOUDHSM =>
      val r = AWS_CLOUDHSM
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.OriginType {
    override def unwrap: software.amazon.awssdk.services.kms.model.OriginType =
      software.amazon.awssdk.services.kms.model.OriginType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_KMS extends zio.aws.kms.model.OriginType {
    override def unwrap: software.amazon.awssdk.services.kms.model.OriginType =
      software.amazon.awssdk.services.kms.model.OriginType.AWS_KMS
  }
  case object EXTERNAL extends zio.aws.kms.model.OriginType {
    override def unwrap: software.amazon.awssdk.services.kms.model.OriginType =
      software.amazon.awssdk.services.kms.model.OriginType.EXTERNAL
  }
  case object AWS_CLOUDHSM extends zio.aws.kms.model.OriginType {
    override def unwrap: software.amazon.awssdk.services.kms.model.OriginType =
      software.amazon.awssdk.services.kms.model.OriginType.AWS_CLOUDHSM
  }
}
