package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  BooleanType,
  CustomKeyStoreIdType,
  DescriptionType,
  NullableBooleanType,
  PolicyType
}
import scala.jdk.CollectionConverters._
final case class CreateKeyRequest(
    policy: Option[PolicyType] = None,
    description: Option[DescriptionType] = None,
    keyUsage: Option[zio.aws.kms.model.KeyUsageType] = None,
    customerMasterKeySpec: Option[zio.aws.kms.model.CustomerMasterKeySpec] =
      None,
    keySpec: Option[zio.aws.kms.model.KeySpec] = None,
    origin: Option[zio.aws.kms.model.OriginType] = None,
    customKeyStoreId: Option[CustomKeyStoreIdType] = None,
    bypassPolicyLockoutSafetyCheck: Option[BooleanType] = None,
    tags: Option[Iterable[zio.aws.kms.model.Tag]] = None,
    multiRegion: Option[NullableBooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateKeyRequest = {
    import CreateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateKeyRequest
      .builder()
      .optionallyWith(
        policy.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(keyUsage.map(value => value.unwrap))(_.keyUsage)
      .optionallyWith(customerMasterKeySpec.map(value => value.unwrap))(
        _.customerMasterKeySpec
      )
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        bypassPolicyLockoutSafetyCheck.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.bypassPolicyLockoutSafetyCheck)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        multiRegion.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.multiRegion)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateKeyRequest.ReadOnly =
    zio.aws.kms.model.CreateKeyRequest.wrap(buildAwsValue())
}
object CreateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateKeyRequest =
      zio.aws.kms.model.CreateKeyRequest(
        policy.map(value => value),
        description.map(value => value),
        keyUsage.map(value => value),
        customerMasterKeySpec.map(value => value),
        keySpec.map(value => value),
        origin.map(value => value),
        customKeyStoreId.map(value => value),
        bypassPolicyLockoutSafetyCheck.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiRegion.map(value => value)
      )
    def policy: Option[PolicyType]
    def description: Option[DescriptionType]
    def keyUsage: Option[zio.aws.kms.model.KeyUsageType]
    def customerMasterKeySpec: Option[zio.aws.kms.model.CustomerMasterKeySpec]
    def keySpec: Option[zio.aws.kms.model.KeySpec]
    def origin: Option[zio.aws.kms.model.OriginType]
    def customKeyStoreId: Option[CustomKeyStoreIdType]
    def bypassPolicyLockoutSafetyCheck: Option[BooleanType]
    def tags: Option[List[zio.aws.kms.model.Tag.ReadOnly]]
    def multiRegion: Option[NullableBooleanType]
    def getPolicy: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("policy", policy)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKeyUsage: ZIO[Any, AwsError, zio.aws.kms.model.KeyUsageType] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getCustomerMasterKeySpec
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomerMasterKeySpec] =
      AwsError.unwrapOptionField("customerMasterKeySpec", customerMasterKeySpec)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.KeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getOrigin: ZIO[Any, AwsError, zio.aws.kms.model.OriginType] =
      AwsError.unwrapOptionField("origin", origin)
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getBypassPolicyLockoutSafetyCheck: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "bypassPolicyLockoutSafetyCheck",
        bypassPolicyLockoutSafetyCheck
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMultiRegion: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("multiRegion", multiRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateKeyRequest
  ) extends zio.aws.kms.model.CreateKeyRequest.ReadOnly {
    override val policy: Option[PolicyType] = scala
      .Option(impl.policy())
      .map(value => zio.aws.kms.model.primitives.PolicyType(value))
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.kms.model.primitives.DescriptionType(value))
    override val keyUsage: Option[zio.aws.kms.model.KeyUsageType] = scala
      .Option(impl.keyUsage())
      .map(value => zio.aws.kms.model.KeyUsageType.wrap(value))
    override val customerMasterKeySpec
        : Option[zio.aws.kms.model.CustomerMasterKeySpec] = scala
      .Option(impl.customerMasterKeySpec())
      .map(value => zio.aws.kms.model.CustomerMasterKeySpec.wrap(value))
    override val keySpec: Option[zio.aws.kms.model.KeySpec] = scala
      .Option(impl.keySpec())
      .map(value => zio.aws.kms.model.KeySpec.wrap(value))
    override val origin: Option[zio.aws.kms.model.OriginType] = scala
      .Option(impl.origin())
      .map(value => zio.aws.kms.model.OriginType.wrap(value))
    override val customKeyStoreId: Option[CustomKeyStoreIdType] = scala
      .Option(impl.customKeyStoreId())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val bypassPolicyLockoutSafetyCheck: Option[BooleanType] = scala
      .Option(impl.bypassPolicyLockoutSafetyCheck())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val tags: Option[List[zio.aws.kms.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.Tag.wrap(item)
        }.toList
      )
    override val multiRegion: Option[NullableBooleanType] = scala
      .Option(impl.multiRegion())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateKeyRequest
  ): zio.aws.kms.model.CreateKeyRequest.ReadOnly = new Wrapper(impl)
}
