package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  CiphertextType,
  EncryptionContextValue,
  EncryptionContextKey
}
import scala.jdk.CollectionConverters._
final case class ReEncryptRequest(
    ciphertextBlob: CiphertextType,
    sourceEncryptionContext: Option[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = None,
    sourceKeyId: Option[KeyIdType] = None,
    destinationKeyId: KeyIdType,
    destinationEncryptionContext: Option[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = None,
    sourceEncryptionAlgorithm: Option[
      zio.aws.kms.model.EncryptionAlgorithmSpec
    ] = None,
    destinationEncryptionAlgorithm: Option[
      zio.aws.kms.model.EncryptionAlgorithmSpec
    ] = None,
    grantTokens: Option[Iterable[GrantTokenType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ReEncryptRequest = {
    import ReEncryptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ReEncryptRequest
      .builder()
      .ciphertextBlob(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          ciphertextBlob.toArray[Byte]
        )
      )
      .optionallyWith(
        sourceEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.sourceEncryptionContext)
      .optionallyWith(
        sourceKeyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.sourceKeyId)
      .destinationKeyId(KeyIdType.unwrap(destinationKeyId): java.lang.String)
      .optionallyWith(
        destinationEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.destinationEncryptionContext)
      .optionallyWith(sourceEncryptionAlgorithm.map(value => value.unwrap))(
        _.sourceEncryptionAlgorithm
      )
      .optionallyWith(
        destinationEncryptionAlgorithm.map(value => value.unwrap)
      )(_.destinationEncryptionAlgorithm)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ReEncryptRequest.ReadOnly =
    zio.aws.kms.model.ReEncryptRequest.wrap(buildAwsValue())
}
object ReEncryptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ReEncryptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ReEncryptRequest =
      zio.aws.kms.model.ReEncryptRequest(
        ciphertextBlob,
        sourceEncryptionContext.map(value => value),
        sourceKeyId.map(value => value),
        destinationKeyId,
        destinationEncryptionContext.map(value => value),
        sourceEncryptionAlgorithm.map(value => value),
        destinationEncryptionAlgorithm.map(value => value),
        grantTokens.map(value => value)
      )
    def ciphertextBlob: CiphertextType
    def sourceEncryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]]
    def sourceKeyId: Option[KeyIdType]
    def destinationKeyId: KeyIdType
    def destinationEncryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]]
    def sourceEncryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def destinationEncryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def grantTokens: Option[List[GrantTokenType]]
    def getCiphertextBlob: ZIO[Any, Nothing, CiphertextType] =
      ZIO.succeed(ciphertextBlob)
    def getSourceEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField(
      "sourceEncryptionContext",
      sourceEncryptionContext
    )
    def getSourceKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("sourceKeyId", sourceKeyId)
    def getDestinationKeyId: ZIO[Any, Nothing, KeyIdType] =
      ZIO.succeed(destinationKeyId)
    def getDestinationEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField(
      "destinationEncryptionContext",
      destinationEncryptionContext
    )
    def getSourceEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField(
        "sourceEncryptionAlgorithm",
        sourceEncryptionAlgorithm
      )
    def getDestinationEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField(
        "destinationEncryptionAlgorithm",
        destinationEncryptionAlgorithm
      )
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ReEncryptRequest
  ) extends zio.aws.kms.model.ReEncryptRequest.ReadOnly {
    override val ciphertextBlob: CiphertextType =
      zio.aws.kms.model.primitives.CiphertextType(
        zio.Chunk.fromArray(impl.ciphertextBlob().asByteArrayUnsafe())
      )
    override val sourceEncryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]] = scala
      .Option(impl.sourceEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kms.model.primitives.EncryptionContextKey(
              key
            ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
          })
          .toMap
      )
    override val sourceKeyId: Option[KeyIdType] = scala
      .Option(impl.sourceKeyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val destinationKeyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.destinationKeyId())
    override val destinationEncryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]] = scala
      .Option(impl.destinationEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kms.model.primitives.EncryptionContextKey(
              key
            ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
          })
          .toMap
      )
    override val sourceEncryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec] = scala
      .Option(impl.sourceEncryptionAlgorithm())
      .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val destinationEncryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec] = scala
      .Option(impl.destinationEncryptionAlgorithm())
      .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ReEncryptRequest
  ): zio.aws.kms.model.ReEncryptRequest.ReadOnly = new Wrapper(impl)
}
