package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait KeyManagerType {
  def unwrap: software.amazon.awssdk.services.kms.model.KeyManagerType
}
object KeyManagerType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.KeyManagerType
  ): zio.aws.kms.model.KeyManagerType = value match {
    case software.amazon.awssdk.services.kms.model.KeyManagerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.KeyManagerType.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.kms.model.KeyManagerType.CUSTOMER =>
      val r = CUSTOMER
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.KeyManagerType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyManagerType =
      software.amazon.awssdk.services.kms.model.KeyManagerType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS extends zio.aws.kms.model.KeyManagerType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyManagerType =
      software.amazon.awssdk.services.kms.model.KeyManagerType.AWS
  }
  case object CUSTOMER extends zio.aws.kms.model.KeyManagerType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyManagerType =
      software.amazon.awssdk.services.kms.model.KeyManagerType.CUSTOMER
  }
}
