package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  KeyIdType,
  GrantIdType,
  DateType,
  PrincipalIdType,
  GrantNameType
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GrantListEntry(
    keyId: Option[KeyIdType] = None,
    grantId: Option[GrantIdType] = None,
    name: Option[GrantNameType] = None,
    creationDate: Option[DateType] = None,
    granteePrincipal: Option[PrincipalIdType] = None,
    retiringPrincipal: Option[PrincipalIdType] = None,
    issuingAccount: Option[PrincipalIdType] = None,
    operations: Option[Iterable[zio.aws.kms.model.GrantOperation]] = None,
    constraints: Option[zio.aws.kms.model.GrantConstraints] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GrantListEntry = {
    import GrantListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GrantListEntry
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        grantId.map(value => GrantIdType.unwrap(value): java.lang.String)
      )(_.grantId)
      .optionallyWith(
        name.map(value => GrantNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        granteePrincipal.map(value =>
          PrincipalIdType.unwrap(value): java.lang.String
        )
      )(_.granteePrincipal)
      .optionallyWith(
        retiringPrincipal.map(value =>
          PrincipalIdType.unwrap(value): java.lang.String
        )
      )(_.retiringPrincipal)
      .optionallyWith(
        issuingAccount.map(value =>
          PrincipalIdType.unwrap(value): java.lang.String
        )
      )(_.issuingAccount)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.operationsWithStrings)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GrantListEntry.ReadOnly =
    zio.aws.kms.model.GrantListEntry.wrap(buildAwsValue())
}
object GrantListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GrantListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GrantListEntry =
      zio.aws.kms.model.GrantListEntry(
        keyId.map(value => value),
        grantId.map(value => value),
        name.map(value => value),
        creationDate.map(value => value),
        granteePrincipal.map(value => value),
        retiringPrincipal.map(value => value),
        issuingAccount.map(value => value),
        operations.map(value => value),
        constraints.map(value => value.asEditable)
      )
    def keyId: Option[KeyIdType]
    def grantId: Option[GrantIdType]
    def name: Option[GrantNameType]
    def creationDate: Option[DateType]
    def granteePrincipal: Option[PrincipalIdType]
    def retiringPrincipal: Option[PrincipalIdType]
    def issuingAccount: Option[PrincipalIdType]
    def operations: Option[List[zio.aws.kms.model.GrantOperation]]
    def constraints: Option[zio.aws.kms.model.GrantConstraints.ReadOnly]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getGrantId: ZIO[Any, AwsError, GrantIdType] =
      AwsError.unwrapOptionField("grantId", grantId)
    def getName: ZIO[Any, AwsError, GrantNameType] =
      AwsError.unwrapOptionField("name", name)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getGranteePrincipal: ZIO[Any, AwsError, PrincipalIdType] =
      AwsError.unwrapOptionField("granteePrincipal", granteePrincipal)
    def getRetiringPrincipal: ZIO[Any, AwsError, PrincipalIdType] =
      AwsError.unwrapOptionField("retiringPrincipal", retiringPrincipal)
    def getIssuingAccount: ZIO[Any, AwsError, PrincipalIdType] =
      AwsError.unwrapOptionField("issuingAccount", issuingAccount)
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.kms.model.GrantOperation]] =
      AwsError.unwrapOptionField("operations", operations)
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.kms.model.GrantConstraints.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GrantListEntry
  ) extends zio.aws.kms.model.GrantListEntry.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val grantId: Option[GrantIdType] = scala
      .Option(impl.grantId())
      .map(value => zio.aws.kms.model.primitives.GrantIdType(value))
    override val name: Option[GrantNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.kms.model.primitives.GrantNameType(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val granteePrincipal: Option[PrincipalIdType] = scala
      .Option(impl.granteePrincipal())
      .map(value => zio.aws.kms.model.primitives.PrincipalIdType(value))
    override val retiringPrincipal: Option[PrincipalIdType] = scala
      .Option(impl.retiringPrincipal())
      .map(value => zio.aws.kms.model.primitives.PrincipalIdType(value))
    override val issuingAccount: Option[PrincipalIdType] = scala
      .Option(impl.issuingAccount())
      .map(value => zio.aws.kms.model.primitives.PrincipalIdType(value))
    override val operations: Option[List[zio.aws.kms.model.GrantOperation]] =
      scala
        .Option(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.GrantOperation.wrap(item)
          }.toList
        )
    override val constraints
        : Option[zio.aws.kms.model.GrantConstraints.ReadOnly] = scala
      .Option(impl.constraints())
      .map(value => zio.aws.kms.model.GrantConstraints.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GrantListEntry
  ): zio.aws.kms.model.GrantListEntry.ReadOnly = new Wrapper(impl)
}
