package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import scala.jdk.CollectionConverters._
final case class ListGrantsResponse(
    grants: Option[Iterable[zio.aws.kms.model.GrantListEntry]] = None,
    nextMarker: Option[MarkerType] = None,
    truncated: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListGrantsResponse = {
    import ListGrantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListGrantsResponse
      .builder()
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListGrantsResponse.ReadOnly =
    zio.aws.kms.model.ListGrantsResponse.wrap(buildAwsValue())
}
object ListGrantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListGrantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListGrantsResponse =
      zio.aws.kms.model.ListGrantsResponse(
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def grants: Option[List[zio.aws.kms.model.GrantListEntry.ReadOnly]]
    def nextMarker: Option[MarkerType]
    def truncated: Option[BooleanType]
    def getGrants
        : ZIO[Any, AwsError, List[zio.aws.kms.model.GrantListEntry.ReadOnly]] =
      AwsError.unwrapOptionField("grants", grants)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListGrantsResponse
  ) extends zio.aws.kms.model.ListGrantsResponse.ReadOnly {
    override val grants
        : Option[List[zio.aws.kms.model.GrantListEntry.ReadOnly]] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.GrantListEntry.wrap(item)
        }.toList
      )
    override val nextMarker: Option[MarkerType] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Option[BooleanType] = scala
      .Option(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListGrantsResponse
  ): zio.aws.kms.model.ListGrantsResponse.ReadOnly = new Wrapper(impl)
}
