package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.CustomKeyStoreIdType
import scala.jdk.CollectionConverters._
final case class CreateCustomKeyStoreResponse(
    customKeyStoreId: Option[CustomKeyStoreIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse = {
    import CreateCustomKeyStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse
      .builder()
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly =
    zio.aws.kms.model.CreateCustomKeyStoreResponse.wrap(buildAwsValue())
}
object CreateCustomKeyStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateCustomKeyStoreResponse =
      zio.aws.kms.model
        .CreateCustomKeyStoreResponse(customKeyStoreId.map(value => value))
    def customKeyStoreId: Option[CustomKeyStoreIdType]
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse
  ) extends zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly {
    override val customKeyStoreId: Option[CustomKeyStoreIdType] = scala
      .Option(impl.customKeyStoreId())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse
  ): zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly = new Wrapper(impl)
}
