package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, CiphertextType}
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyWithoutPlaintextResponse(
    ciphertextBlob: Option[CiphertextType] = None,
    keyId: Option[KeyIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse = {
    import GenerateDataKeyWithoutPlaintextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
      .builder()
      .optionallyWith(
        ciphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.ciphertextBlob)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse
      .wrap(buildAwsValue())
}
object GenerateDataKeyWithoutPlaintextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse =
      zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse(
        ciphertextBlob.map(value => value),
        keyId.map(value => value)
      )
    def ciphertextBlob: Option[CiphertextType]
    def keyId: Option[KeyIdType]
    def getCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("ciphertextBlob", ciphertextBlob)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
  ) extends zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly {
    override val ciphertextBlob: Option[CiphertextType] = scala
      .Option(impl.ciphertextBlob())
      .map(value =>
        zio.aws.kms.model.primitives
          .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
  ): zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly =
    new Wrapper(impl)
}
