package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  MarkerType,
  LimitType,
  CustomKeyStoreNameType,
  CustomKeyStoreIdType
}
import scala.jdk.CollectionConverters._
final case class DescribeCustomKeyStoresRequest(
    customKeyStoreId: Option[CustomKeyStoreIdType] = None,
    customKeyStoreName: Option[CustomKeyStoreNameType] = None,
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest = {
    import DescribeCustomKeyStoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest
      .builder()
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        customKeyStoreName.map(value =>
          CustomKeyStoreNameType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreName)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DescribeCustomKeyStoresRequest.ReadOnly =
    zio.aws.kms.model.DescribeCustomKeyStoresRequest.wrap(buildAwsValue())
}
object DescribeCustomKeyStoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DescribeCustomKeyStoresRequest =
      zio.aws.kms.model.DescribeCustomKeyStoresRequest(
        customKeyStoreId.map(value => value),
        customKeyStoreName.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def customKeyStoreId: Option[CustomKeyStoreIdType]
    def customKeyStoreName: Option[CustomKeyStoreNameType]
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getCustomKeyStoreName: ZIO[Any, AwsError, CustomKeyStoreNameType] =
      AwsError.unwrapOptionField("customKeyStoreName", customKeyStoreName)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest
  ) extends zio.aws.kms.model.DescribeCustomKeyStoresRequest.ReadOnly {
    override val customKeyStoreId: Option[CustomKeyStoreIdType] = scala
      .Option(impl.customKeyStoreId())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val customKeyStoreName: Option[CustomKeyStoreNameType] = scala
      .Option(impl.customKeyStoreName())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreNameType(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest
  ): zio.aws.kms.model.DescribeCustomKeyStoresRequest.ReadOnly = new Wrapper(
    impl
  )
}
