package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{GrantTokenType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class DescribeKeyRequest(
    keyId: KeyIdType,
    grantTokens: Option[Iterable[GrantTokenType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DescribeKeyRequest = {
    import DescribeKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DescribeKeyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DescribeKeyRequest.ReadOnly =
    zio.aws.kms.model.DescribeKeyRequest.wrap(buildAwsValue())
}
object DescribeKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DescribeKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DescribeKeyRequest = zio.aws.kms.model
      .DescribeKeyRequest(keyId, grantTokens.map(value => value))
    def keyId: KeyIdType
    def grantTokens: Option[List[GrantTokenType]]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DescribeKeyRequest
  ) extends zio.aws.kms.model.DescribeKeyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DescribeKeyRequest
  ): zio.aws.kms.model.DescribeKeyRequest.ReadOnly = new Wrapper(impl)
}
