package zio.aws.kms.model
import java.time.Instant
import zio.aws.kms.model.primitives.{
  PendingWindowInDaysType,
  DateType,
  KeyIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ScheduleKeyDeletionResponse(
    keyId: Option[KeyIdType] = None,
    deletionDate: Option[DateType] = None,
    keyState: Option[zio.aws.kms.model.KeyState] = None,
    pendingWindowInDays: Option[PendingWindowInDaysType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse = {
    import ScheduleKeyDeletionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        deletionDate.map(value => DateType.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(keyState.map(value => value.unwrap))(_.keyState)
      .optionallyWith(
        pendingWindowInDays.map(value =>
          PendingWindowInDaysType.unwrap(value): Integer
        )
      )(_.pendingWindowInDays)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly =
    zio.aws.kms.model.ScheduleKeyDeletionResponse.wrap(buildAwsValue())
}
object ScheduleKeyDeletionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ScheduleKeyDeletionResponse =
      zio.aws.kms.model.ScheduleKeyDeletionResponse(
        keyId.map(value => value),
        deletionDate.map(value => value),
        keyState.map(value => value),
        pendingWindowInDays.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def deletionDate: Option[DateType]
    def keyState: Option[zio.aws.kms.model.KeyState]
    def pendingWindowInDays: Option[PendingWindowInDaysType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getDeletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getKeyState: ZIO[Any, AwsError, zio.aws.kms.model.KeyState] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getPendingWindowInDays: ZIO[Any, AwsError, PendingWindowInDaysType] =
      AwsError.unwrapOptionField("pendingWindowInDays", pendingWindowInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
  ) extends zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val deletionDate: Option[DateType] = scala
      .Option(impl.deletionDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val keyState: Option[zio.aws.kms.model.KeyState] = scala
      .Option(impl.keyState())
      .map(value => zio.aws.kms.model.KeyState.wrap(value))
    override val pendingWindowInDays: Option[PendingWindowInDaysType] = scala
      .Option(impl.pendingWindowInDays())
      .map(value => zio.aws.kms.model.primitives.PendingWindowInDaysType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
  ): zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly = new Wrapper(impl)
}
