package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{PublicKeyType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class GetPublicKeyResponse(
    keyId: Option[KeyIdType] = None,
    publicKey: Option[PublicKeyType] = None,
    customerMasterKeySpec: Option[zio.aws.kms.model.CustomerMasterKeySpec] =
      None,
    keySpec: Option[zio.aws.kms.model.KeySpec] = None,
    keyUsage: Option[zio.aws.kms.model.KeyUsageType] = None,
    encryptionAlgorithms: Option[
      Iterable[zio.aws.kms.model.EncryptionAlgorithmSpec]
    ] = None,
    signingAlgorithms: Option[
      Iterable[zio.aws.kms.model.SigningAlgorithmSpec]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetPublicKeyResponse = {
    import GetPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        publicKey.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.publicKey)
      .optionallyWith(customerMasterKeySpec.map(value => value.unwrap))(
        _.customerMasterKeySpec
      )
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(keyUsage.map(value => value.unwrap))(_.keyUsage)
      .optionallyWith(
        encryptionAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.encryptionAlgorithmsWithStrings)
      .optionallyWith(
        signingAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.signingAlgorithmsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetPublicKeyResponse.ReadOnly =
    zio.aws.kms.model.GetPublicKeyResponse.wrap(buildAwsValue())
}
object GetPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetPublicKeyResponse =
      zio.aws.kms.model.GetPublicKeyResponse(
        keyId.map(value => value),
        publicKey.map(value => value),
        customerMasterKeySpec.map(value => value),
        keySpec.map(value => value),
        keyUsage.map(value => value),
        encryptionAlgorithms.map(value => value),
        signingAlgorithms.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def publicKey: Option[PublicKeyType]
    def customerMasterKeySpec: Option[zio.aws.kms.model.CustomerMasterKeySpec]
    def keySpec: Option[zio.aws.kms.model.KeySpec]
    def keyUsage: Option[zio.aws.kms.model.KeyUsageType]
    def encryptionAlgorithms
        : Option[List[zio.aws.kms.model.EncryptionAlgorithmSpec]]
    def signingAlgorithms: Option[List[zio.aws.kms.model.SigningAlgorithmSpec]]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getPublicKey: ZIO[Any, AwsError, PublicKeyType] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getCustomerMasterKeySpec
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomerMasterKeySpec] =
      AwsError.unwrapOptionField("customerMasterKeySpec", customerMasterKeySpec)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.KeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getKeyUsage: ZIO[Any, AwsError, zio.aws.kms.model.KeyUsageType] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getEncryptionAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.EncryptionAlgorithmSpec]] =
      AwsError.unwrapOptionField("encryptionAlgorithms", encryptionAlgorithms)
    def getSigningAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.SigningAlgorithmSpec]] =
      AwsError.unwrapOptionField("signingAlgorithms", signingAlgorithms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
  ) extends zio.aws.kms.model.GetPublicKeyResponse.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val publicKey: Option[PublicKeyType] = scala
      .Option(impl.publicKey())
      .map(value =>
        zio.aws.kms.model.primitives
          .PublicKeyType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val customerMasterKeySpec
        : Option[zio.aws.kms.model.CustomerMasterKeySpec] = scala
      .Option(impl.customerMasterKeySpec())
      .map(value => zio.aws.kms.model.CustomerMasterKeySpec.wrap(value))
    override val keySpec: Option[zio.aws.kms.model.KeySpec] = scala
      .Option(impl.keySpec())
      .map(value => zio.aws.kms.model.KeySpec.wrap(value))
    override val keyUsage: Option[zio.aws.kms.model.KeyUsageType] = scala
      .Option(impl.keyUsage())
      .map(value => zio.aws.kms.model.KeyUsageType.wrap(value))
    override val encryptionAlgorithms
        : Option[List[zio.aws.kms.model.EncryptionAlgorithmSpec]] = scala
      .Option(impl.encryptionAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(item)
        }.toList
      )
    override val signingAlgorithms
        : Option[List[zio.aws.kms.model.SigningAlgorithmSpec]] = scala
      .Option(impl.signingAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.SigningAlgorithmSpec.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
  ): zio.aws.kms.model.GetPublicKeyResponse.ReadOnly = new Wrapper(impl)
}
