package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  CiphertextType,
  EncryptionContextValue,
  EncryptionContextKey
}
import scala.jdk.CollectionConverters._
final case class DecryptRequest(
    ciphertextBlob: CiphertextType,
    encryptionContext: Option[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = None,
    grantTokens: Option[Iterable[GrantTokenType]] = None,
    keyId: Option[KeyIdType] = None,
    encryptionAlgorithm: Option[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DecryptRequest = {
    import DecryptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DecryptRequest
      .builder()
      .ciphertextBlob(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          ciphertextBlob.toArray[Byte]
        )
      )
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DecryptRequest.ReadOnly =
    zio.aws.kms.model.DecryptRequest.wrap(buildAwsValue())
}
object DecryptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DecryptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DecryptRequest =
      zio.aws.kms.model.DecryptRequest(
        ciphertextBlob,
        encryptionContext.map(value => value),
        grantTokens.map(value => value),
        keyId.map(value => value),
        encryptionAlgorithm.map(value => value)
      )
    def ciphertextBlob: CiphertextType
    def encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]]
    def grantTokens: Option[List[GrantTokenType]]
    def keyId: Option[KeyIdType]
    def encryptionAlgorithm: Option[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def getCiphertextBlob: ZIO[Any, Nothing, CiphertextType] =
      ZIO.succeed(ciphertextBlob)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DecryptRequest
  ) extends zio.aws.kms.model.DecryptRequest.ReadOnly {
    override val ciphertextBlob: CiphertextType =
      zio.aws.kms.model.primitives.CiphertextType(
        zio.Chunk.fromArray(impl.ciphertextBlob().asByteArrayUnsafe())
      )
    override val encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]] = scala
      .Option(impl.encryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kms.model.primitives.EncryptionContextKey(
              key
            ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
          })
          .toMap
      )
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val encryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec] = scala
      .Option(impl.encryptionAlgorithm())
      .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DecryptRequest
  ): zio.aws.kms.model.DecryptRequest.ReadOnly = new Wrapper(impl)
}
