package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{RegionType, ArnType}
import scala.jdk.CollectionConverters._
final case class MultiRegionKey(
    arn: Option[ArnType] = None,
    region: Option[RegionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.MultiRegionKey = {
    import MultiRegionKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.MultiRegionKey
      .builder()
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        region.map(value => RegionType.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.MultiRegionKey.ReadOnly =
    zio.aws.kms.model.MultiRegionKey.wrap(buildAwsValue())
}
object MultiRegionKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.MultiRegionKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.MultiRegionKey = zio.aws.kms.model
      .MultiRegionKey(arn.map(value => value), region.map(value => value))
    def arn: Option[ArnType]
    def region: Option[RegionType]
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getRegion: ZIO[Any, AwsError, RegionType] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.MultiRegionKey
  ) extends zio.aws.kms.model.MultiRegionKey.ReadOnly {
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.kms.model.primitives.ArnType(value))
    override val region: Option[RegionType] = scala
      .Option(impl.region())
      .map(value => zio.aws.kms.model.primitives.RegionType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.MultiRegionKey
  ): zio.aws.kms.model.MultiRegionKey.ReadOnly = new Wrapper(impl)
}
