package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, PublicKeyType, CiphertextType}
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyPairWithoutPlaintextResponse(
    privateKeyCiphertextBlob: Option[CiphertextType] = None,
    publicKey: Option[PublicKeyType] = None,
    keyId: Option[KeyIdType] = None,
    keyPairSpec: Option[zio.aws.kms.model.DataKeyPairSpec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse = {
    import GenerateDataKeyPairWithoutPlaintextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
      .builder()
      .optionallyWith(
        privateKeyCiphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.privateKeyCiphertextBlob)
      .optionallyWith(
        publicKey.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.publicKey)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(keyPairSpec.map(value => value.unwrap))(_.keyPairSpec)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
      .wrap(buildAwsValue())
}
object GenerateDataKeyPairWithoutPlaintextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse =
      zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse(
        privateKeyCiphertextBlob.map(value => value),
        publicKey.map(value => value),
        keyId.map(value => value),
        keyPairSpec.map(value => value)
      )
    def privateKeyCiphertextBlob: Option[CiphertextType]
    def publicKey: Option[PublicKeyType]
    def keyId: Option[KeyIdType]
    def keyPairSpec: Option[zio.aws.kms.model.DataKeyPairSpec]
    def getPrivateKeyCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField(
        "privateKeyCiphertextBlob",
        privateKeyCiphertextBlob
      )
    def getPublicKey: ZIO[Any, AwsError, PublicKeyType] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getKeyPairSpec: ZIO[Any, AwsError, zio.aws.kms.model.DataKeyPairSpec] =
      AwsError.unwrapOptionField("keyPairSpec", keyPairSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
  ) extends zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly {
    override val privateKeyCiphertextBlob: Option[CiphertextType] = scala
      .Option(impl.privateKeyCiphertextBlob())
      .map(value =>
        zio.aws.kms.model.primitives
          .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val publicKey: Option[PublicKeyType] = scala
      .Option(impl.publicKey())
      .map(value =>
        zio.aws.kms.model.primitives
          .PublicKeyType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val keyPairSpec: Option[zio.aws.kms.model.DataKeyPairSpec] = scala
      .Option(impl.keyPairSpec())
      .map(value => zio.aws.kms.model.DataKeyPairSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse
  ): zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly =
    new Wrapper(impl)
}
