package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{CiphertextType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class SignResponse(
    keyId: Option[KeyIdType] = None,
    signature: Option[CiphertextType] = None,
    signingAlgorithm: Option[zio.aws.kms.model.SigningAlgorithmSpec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.SignResponse = {
    import SignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.SignResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        signature.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.signature)
      .optionallyWith(signingAlgorithm.map(value => value.unwrap))(
        _.signingAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.SignResponse.ReadOnly =
    zio.aws.kms.model.SignResponse.wrap(buildAwsValue())
}
object SignResponse {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.SignResponse] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.SignResponse =
      zio.aws.kms.model.SignResponse(
        keyId.map(value => value),
        signature.map(value => value),
        signingAlgorithm.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def signature: Option[CiphertextType]
    def signingAlgorithm: Option[zio.aws.kms.model.SigningAlgorithmSpec]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getSignature: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("signature", signature)
    def getSigningAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.SigningAlgorithmSpec] =
      AwsError.unwrapOptionField("signingAlgorithm", signingAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.SignResponse
  ) extends zio.aws.kms.model.SignResponse.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val signature: Option[CiphertextType] = scala
      .Option(impl.signature())
      .map(value =>
        zio.aws.kms.model.primitives
          .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val signingAlgorithm
        : Option[zio.aws.kms.model.SigningAlgorithmSpec] = scala
      .Option(impl.signingAlgorithm())
      .map(value => zio.aws.kms.model.SigningAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.SignResponse
  ): zio.aws.kms.model.SignResponse.ReadOnly = new Wrapper(impl)
}
