package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  EncryptionContextKey
}
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyPairWithoutPlaintextRequest(
    encryptionContext: Option[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = None,
    keyId: KeyIdType,
    keyPairSpec: zio.aws.kms.model.DataKeyPairSpec,
    grantTokens: Option[Iterable[GrantTokenType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest = {
    import GenerateDataKeyPairWithoutPlaintextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
      .builder()
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .keyPairSpec(keyPairSpec.unwrap)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
      .wrap(buildAwsValue())
}
object GenerateDataKeyPairWithoutPlaintextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest =
      zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest(
        encryptionContext.map(value => value),
        keyId,
        keyPairSpec,
        grantTokens.map(value => value)
      )
    def encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]]
    def keyId: KeyIdType
    def keyPairSpec: zio.aws.kms.model.DataKeyPairSpec
    def grantTokens: Option[List[GrantTokenType]]
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getKeyPairSpec: ZIO[Any, Nothing, zio.aws.kms.model.DataKeyPairSpec] =
      ZIO.succeed(keyPairSpec)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
  ) extends zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest.ReadOnly {
    override val encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]] = scala
      .Option(impl.encryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kms.model.primitives.EncryptionContextKey(
              key
            ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
          })
          .toMap
      )
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val keyPairSpec: zio.aws.kms.model.DataKeyPairSpec =
      zio.aws.kms.model.DataKeyPairSpec.wrap(impl.keyPairSpec())
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest
  ): zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextRequest.ReadOnly =
    new Wrapper(impl)
}
