package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{PrincipalIdType, MarkerType, LimitType}
import scala.jdk.CollectionConverters._
final case class ListRetirableGrantsRequest(
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None,
    retiringPrincipal: PrincipalIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest = {
    import ListRetirableGrantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest
      .builder()
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .retiringPrincipal(
        PrincipalIdType.unwrap(retiringPrincipal): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListRetirableGrantsRequest.ReadOnly =
    zio.aws.kms.model.ListRetirableGrantsRequest.wrap(buildAwsValue())
}
object ListRetirableGrantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListRetirableGrantsRequest =
      zio.aws.kms.model.ListRetirableGrantsRequest(
        limit.map(value => value),
        marker.map(value => value),
        retiringPrincipal
      )
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def retiringPrincipal: PrincipalIdType
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getRetiringPrincipal: ZIO[Any, Nothing, PrincipalIdType] =
      ZIO.succeed(retiringPrincipal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest
  ) extends zio.aws.kms.model.ListRetirableGrantsRequest.ReadOnly {
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val retiringPrincipal: PrincipalIdType =
      zio.aws.kms.model.primitives.PrincipalIdType(impl.retiringPrincipal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest
  ): zio.aws.kms.model.ListRetirableGrantsRequest.ReadOnly = new Wrapper(impl)
}
