package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.PlaintextType
import scala.jdk.CollectionConverters._
final case class GenerateRandomResponse(
    plaintext: Option[PlaintextType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateRandomResponse = {
    import GenerateRandomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateRandomResponse
      .builder()
      .optionallyWith(
        plaintext.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.plaintext)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateRandomResponse.ReadOnly =
    zio.aws.kms.model.GenerateRandomResponse.wrap(buildAwsValue())
}
object GenerateRandomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateRandomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateRandomResponse =
      zio.aws.kms.model.GenerateRandomResponse(plaintext.map(value => value))
    def plaintext: Option[PlaintextType]
    def getPlaintext: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("plaintext", plaintext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateRandomResponse
  ) extends zio.aws.kms.model.GenerateRandomResponse.ReadOnly {
    override val plaintext: Option[PlaintextType] = scala
      .Option(impl.plaintext())
      .map(value =>
        zio.aws.kms.model.primitives
          .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateRandomResponse
  ): zio.aws.kms.model.GenerateRandomResponse.ReadOnly = new Wrapper(impl)
}
