package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeKeyResponse(
    keyMetadata: Option[zio.aws.kms.model.KeyMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DescribeKeyResponse = {
    import DescribeKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DescribeKeyResponse
      .builder()
      .optionallyWith(keyMetadata.map(value => value.buildAwsValue()))(
        _.keyMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DescribeKeyResponse.ReadOnly =
    zio.aws.kms.model.DescribeKeyResponse.wrap(buildAwsValue())
}
object DescribeKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DescribeKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DescribeKeyResponse = zio.aws.kms.model
      .DescribeKeyResponse(keyMetadata.map(value => value.asEditable))
    def keyMetadata: Option[zio.aws.kms.model.KeyMetadata.ReadOnly]
    def getKeyMetadata
        : ZIO[Any, AwsError, zio.aws.kms.model.KeyMetadata.ReadOnly] =
      AwsError.unwrapOptionField("keyMetadata", keyMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DescribeKeyResponse
  ) extends zio.aws.kms.model.DescribeKeyResponse.ReadOnly {
    override val keyMetadata: Option[zio.aws.kms.model.KeyMetadata.ReadOnly] =
      scala
        .Option(impl.keyMetadata())
        .map(value => zio.aws.kms.model.KeyMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DescribeKeyResponse
  ): zio.aws.kms.model.DescribeKeyResponse.ReadOnly = new Wrapper(impl)
}
