package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantNameType,
  GrantTokenType,
  PrincipalIdType,
  KeyIdType
}
import scala.jdk.CollectionConverters._
final case class CreateGrantRequest(
    keyId: KeyIdType,
    granteePrincipal: PrincipalIdType,
    retiringPrincipal: Option[PrincipalIdType] = None,
    operations: Iterable[zio.aws.kms.model.GrantOperation],
    constraints: Option[zio.aws.kms.model.GrantConstraints] = None,
    grantTokens: Option[Iterable[GrantTokenType]] = None,
    name: Option[GrantNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateGrantRequest = {
    import CreateGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateGrantRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .granteePrincipal(
        PrincipalIdType.unwrap(granteePrincipal): java.lang.String
      )
      .optionallyWith(
        retiringPrincipal.map(value =>
          PrincipalIdType.unwrap(value): java.lang.String
        )
      )(_.retiringPrincipal)
      .operationsWithStrings(operations.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        name.map(value => GrantNameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateGrantRequest.ReadOnly =
    zio.aws.kms.model.CreateGrantRequest.wrap(buildAwsValue())
}
object CreateGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateGrantRequest =
      zio.aws.kms.model.CreateGrantRequest(
        keyId,
        granteePrincipal,
        retiringPrincipal.map(value => value),
        operations,
        constraints.map(value => value.asEditable),
        grantTokens.map(value => value),
        name.map(value => value)
      )
    def keyId: KeyIdType
    def granteePrincipal: PrincipalIdType
    def retiringPrincipal: Option[PrincipalIdType]
    def operations: List[zio.aws.kms.model.GrantOperation]
    def constraints: Option[zio.aws.kms.model.GrantConstraints.ReadOnly]
    def grantTokens: Option[List[GrantTokenType]]
    def name: Option[GrantNameType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getGranteePrincipal: ZIO[Any, Nothing, PrincipalIdType] =
      ZIO.succeed(granteePrincipal)
    def getRetiringPrincipal: ZIO[Any, AwsError, PrincipalIdType] =
      AwsError.unwrapOptionField("retiringPrincipal", retiringPrincipal)
    def getOperations
        : ZIO[Any, Nothing, List[zio.aws.kms.model.GrantOperation]] =
      ZIO.succeed(operations)
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.kms.model.GrantConstraints.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getName: ZIO[Any, AwsError, GrantNameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateGrantRequest
  ) extends zio.aws.kms.model.CreateGrantRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val granteePrincipal: PrincipalIdType =
      zio.aws.kms.model.primitives.PrincipalIdType(impl.granteePrincipal())
    override val retiringPrincipal: Option[PrincipalIdType] = scala
      .Option(impl.retiringPrincipal())
      .map(value => zio.aws.kms.model.primitives.PrincipalIdType(value))
    override val operations: List[zio.aws.kms.model.GrantOperation] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.kms.model.GrantOperation.wrap(item)
      }
      .toList
    override val constraints
        : Option[zio.aws.kms.model.GrantConstraints.ReadOnly] = scala
      .Option(impl.constraints())
      .map(value => zio.aws.kms.model.GrantConstraints.wrap(value))
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
    override val name: Option[GrantNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.kms.model.primitives.GrantNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateGrantRequest
  ): zio.aws.kms.model.CreateGrantRequest.ReadOnly = new Wrapper(impl)
}
